#' AMAS Dataset
#'
#' This dataset contains measurements of math anxiety using the Abbreviated Math Anxiety Scale (AMAS),
#' collected from 2,200 Amazon Mechanical Turk workers (Keller et al., 2022)
#' This scale consists of 9 items that assess mathematics anxiety, a negative emotional response associated
#' with mathematics-related activities.
#'
#'
#' @name AMAS_WSC
#' @docType data
#' @format AMAS_WSC is a data frame with 2200 cases (rows) and 9 variables (columns).
#' The variables are named item_1, item_2, ... , item_9.
#'
#' @usage data(AMAS_WSC)
#'
#' @references Hopko, D., Mahadevan, R., Bare, R. L., & Hunt, M. K. (2003). The abbreviated math
#' anxiety scale (AMAS): Construction, validity, and reliability. Assessment, 10, 78-182.
#'
#' @keywords datasets
#'
#' @examples
#' AMAS_WSC

NULL
