% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/All.R
\name{Seasonality}
\alias{Seasonality}
\title{Seasonality plot}
\usage{
Seasonality(x, Lines = FALSE)
}
\arguments{
\item{x}{A dataframe with Date or POSIXct in the first folumn and numeric in the second.}

\item{Lines}{Logic with a default of FALSE. If TRUE, lines are plotted instead of dots.}
}
\value{
A seasonality plot
}
\description{
A plot to inspect the seasonality of peak flows
}
\details{
The dots (or dark lines if Lines = TRUE) show the season of individual peaks.
The red line shows the average seasonality. The longer it is the more clustered in time the peaks are.
}
\examples{
# Get an AMAX sample and plot the seasonality
am_27083 <- GetAM(27083)
Seasonality(am_27083)

# Now do the same with lines instead of dots
Seasonality(am_27083, Lines = TRUE)

}
\author{
Anthony Hammond
}
