% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tejapirest.R
\name{Tejapi.rest}
\alias{Tejapi.rest}
\title{Executes Tejapi API calls}
\usage{
Tejapi.rest(path, http = c("GET", "PUT", "POST", "DELETE"),
  postdata = NULL, ...)
}
\arguments{
\item{path}{Path to api resource.}

\item{http}{Type of http request sent.}

\item{postdata}{A character or raw vector that is sent in a body.}

\item{...}{Named values that are interpretted as Tejapi API parameters. Please see \url{https://api.tej.com.tw/documents.html}.}
}
\value{
Tejapi API response.
}
\description{
Executes Tejapi API calls
}
\details{
Set your \code{api_key} with \code{Tejapi.api_key} function. For instructions on finding your api key go to \url{https://api.tej.com.tw}
}
\examples{
\dontrun{
Tejapidata = Tejapi.rest(path="datasets/TWN/AIND", http="GET")
plot(Tejapidata[,1])
}
}
\seealso{
\code{\link{Tejapi.api_key}}
}
