% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ultrametrics.HAR.R
\name{Ultrametrics.HAR}
\alias{Ultrametrics.HAR}
\title{Hit-and-Run Sampler for the space of ultrametrics}
\usage{
Ultrametrics.HAR(x0, n, I = 1, h = 1)
}
\arguments{
\item{x0}{an equidistant tree defined as ultrametric}

\item{n}{number of leaves for the equidistant tree}

\item{I}{number of states in the Markov chain}

\item{h}{height of phylogenetic tree}
}
\value{
point in the space of ultrametrics over n leaves
}
\description{
This sampler samples a point in the space of ultrametrics where each point
represents an equidistant tree on n leaves
}
\examples{
x0 <-Sim_Trees15[1,]
n<-10

Ultrametrics.HAR(x0, n, I = 50, h = 1)

}
\references{
Yoshida, Ruriko, Keiji Miura and David Barnhill (2022). Hit and
Run Sampling from Tropically Convex Sets.
}
\author{
Ruriko Yoshida \email{ryoshida@nps.edu}
}
