% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func.R
\name{SensitivityPlot}
\alias{SensitivityPlot}
\title{Generate sensitivity plots}
\usage{
SensitivityPlot(resList, col, xMax, markHalfPeak = FALSE,
  famLegend = TRUE, rLegend = names(resList), ...)
}
\arguments{
\item{resList}{A list of families returned by \code{\link{EstDynamics}}}

\item{col}{A vector of colors}

\item{xMax}{The maximum of the x-axis}

\item{markHalfPeak}{Whether to mark the time points with half-intensity}

\item{famLegend}{Whether to create legend for families}

\item{rLegend}{Text for the legend for families}

\item{...}{Passed into \code{matplot}}
}
\description{
Create sensitivity plots of a few families to investigate different death rate scenarios
}
\examples{
data(AetLTR)
copia3 <- subset(AetLTR, GroupID == 3 & !is.na(Chr))
copia9 <- subset(AetLTR, GroupID == 9 & !is.na(Chr))
res3 <- EstDynamics(copia3$Mismatch, copia3$UngapedLen)
res9 <- EstDynamics(copia9$Mismatch, copia9$UngapedLen)
SensitivityPlot(list(`Copia 3`=res3, `Copia 9`=res9))
}
