% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GeostTextureLibrarySharedRoxy.R
\name{iqrST}
\alias{iqrST}
\title{iqrST: interquartile range in a moving window}
\usage{
iqrST(x, w = 5, ...)
}
\arguments{
\item{x}{A DEM/image as a SpatRaster}

\item{w}{Search window (e.g., kernelCircular(3)), default 5x5 window}

\item{...}{for further use}
}
\value{
the IQR of the selected property in the search window (same units of the input)
}
\description{
A function to compute IQR with r method type 7 in a search window. It uses
the implemented rcpp version that is many times faster that using focal with IQR() base
R function. It provides the same result as ArcGis Pro.It is intended for computing roughness
indices expressed as a robust (differently from standard deviation) estimate of dispersion
of local surface parameters (e.g., slope, profile curvature, residual surface, etc.).
}
\examples{
dem= rast(paste(system.file("extdata", package = "SurfRough"), "/trento1.tif",sep=""))
# iqr of slope in degrees
slope=terrain(dem, v="slope")
w=KernelCircular(3)
w
iqrSlope=iqrST(slope,w=w)
plot(iqrSlope)
}
\references{
Trevisani, S., Guth, P.L., 2025. Surface Roughness in Geomorphometry: From Basic Metrics Toward a Coherent Framework.
Remote Sensing 17, \doi{doi:10.3390/rs17233864}.
}
