% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_preserved.R
\name{all_preserved}
\alias{all_preserved}
\title{Indestructible fossils}
\usage{
all_preserved(x)
}
\arguments{
\item{x}{taphonomic conditions at which the preservation probability is evaluated}
}
\value{
A vector of the same length as x with all entries replaced by 1.
}
\description{
Models perfect taphonomic conditions. Mainly used as default input to \code{last_occ} and \code{range_offset} or passed as \code{pres_potential} argument to \code{apply_taphonomy}.
}
\examples{
x = p3(rate = 10, 0, 1) # model fossils
y = apply_taphonomy(x, pres_potential = all_preserved, ctc = perfect_preservation)
all(x == y) # true, all fossils are preserved

}
\seealso{
\code{\link[=last_occ]{last_occ()}},  \code{\link[=range_offset]{range_offset()}}, \code{\link[=perfect_preservation]{perfect_preservation()}}, and \code{\link[=apply_taphonomy]{apply_taphonomy()}}
}
