% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{N_Sulphuric}
\alias{N_Sulphuric}
\title{Total Nitrogen (N) using sulphuric acid for ammonia absorption}
\usage{
N_Sulphuric(W = W, VS = VS, VB = VB, X = X)
}
\arguments{
\item{W}{Mass of soil sample (g)}

\item{VS}{Volume of standard sodium hydroxide solution (mL) consumed in titration with soil}

\item{VB}{Volume of standard sodium hydroxide solution (mL) consumed in titration without soil (i.e., blank titration)}

\item{X}{Normality of standard sodium hydroxide solution}
}
\value{
N_pc - Nitrogen in soil (\%)
N_gkg - Nitrogen in soil (g/kg)
N_mgkg - Nitrogen in soil (mg/kg)
N_kgha - Nitrogen in soil (kg/ha)
}
\description{
This function determines the amount of total N in soil given that liberated ammonia gas is absorbed in standard sulphuric acid; and standard sodium hydroxide solution is used for titration.
}
\details{
In a soil, total N can be determined by first digesting the soil with concentrated sulphuric acid in presence of a digestion mixture containing potassium sulphate, cupric sulphate, and selenium powder in the ratio 200: 20: 1 at 390±5 °C till a clear solution (greenish coloured) is obtained. Then the acid digest is distilled with alkali (generally 40\% NaOH) to liberate ammonia gas which is then absorbed in standard sulphuric acid solution (0.1 N or so), and titrated against standard sodium hydroxide solution (0.1 N or so) to know the volume of the sulphuric acid consumed during ammonia absorption (Bremner, 1996; Biswas, 2018).
}
\examples{
with(data = df_N_Sulphuric, N_Sulphuric(W = Mass_Soil, VS = Vol_NaOH_Soil,
VB = Vol_NaOH_Blank, X = Normality_NaOH))

}
\references{
Biswas, D.R. (2018) Determination of different forms of nitrogen in soil and total N in plant. In Manual on Advanced Techniques for Analysis of Nutrients and Pollutant Elements in Soil, Plant and Human (S.P. Datta, M.C. Meena, B.S. Dwivedi, A.K. Shukla (Eds.), Westville Publishing House, New Delhi, pp. 57-68.

Bremner, J.M. (1996) Nitrogen Total. In Methods of Soil Analysis Part 3: Chemical Methods (D.L. Sparks (Eds.), SSSA Book Series 5, Soil Science Society of America, Madison, Wisconsin, pp. 1085-1022.
}
