% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilTesting.R
\name{Mineral_N}
\alias{Mineral_N}
\title{Mineral N i.e., summation of ammonium-N and nitrate-N in soil}
\usage{
Mineral_N(W = W, m = m, VA = VA, VE = VE, VS = VS, VB = VB, X = X)
}
\arguments{
\item{W}{Mass of moist soil sample (g)}

\item{m}{Moisture content of the field-moist soil sample (\% w/w)}

\item{VA}{Volume of aliquot of the extract (mL) taken for distillation}

\item{VE}{Volume of 2 M KCl (mL) added as extractant}

\item{VS}{Volume of standard sulphuric acid solution (mL) consumed in titration with soil}

\item{VB}{Volume of standard sulphuric acid solution (mL) consumed in titration without soil (i.e., blank titration)}

\item{X}{Normality of standard sulphuric acid solution}
}
\value{
N_mgkg - Mineral N in soil (mg/kg) (expressed in terms of oven-dried soil mass)
}
\description{
This function determines the amount of mineral N (ammonium-N + nitrate-N) in soil as extracted by 2 M KCl, expressed in terms of oven-dried soil mass (Rowell, 1994).
}
\details{
Mineral N in soil consists of ammonium and nitrate ions present on soil exchange sites or solution or both. It can be extracted by 2 M KCl. The extract is steam-distilled in the presence of magnesium oxide and Devarda’s alloy (Cu: Al: Zn :: 50: 45: 5) to liberate ammonia. The evolved ammonia is absorbed in 2\% boric acid solution containing mixed indicator, pH 4.5, and titrated against standard sulphuric acid solution to know the volume of the boric acid consumed during ammonia absorption (Rowell, 1994; Biswas, 2018).
}
\examples{
with(data = df_Minearl_N, Mineral_N(W = Mass_Moistsoil, m = Moisture_Percent,
VA = Vol_Aliquot, VE = Vol_Extractant, VS = Vol_Sulphuric_Soil,
VB = Vol_Sulphuric_Blank, X = Normality_Sulphuric))

}
\references{
Biswas, D.R. (2018) Determination of different forms of nitrogen in soil and total N in plant. In Manual on Advanced Techniques for Analysis of Nutrients and Pollutant Elements in Soil, Plant and Human (S.P. Datta, M.C. Meena, B.S. Dwivedi, A.K. Shukla (Eds.)), Westville Publishing House, New Delhi, pp. 57-68.

Rowell, D.L. (1994) Soil Science Methods and Application, Pearson Education Ltd., Essex, England.
}
