% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_BroadBand.R
\name{Get_BroadBand}
\alias{Get_BroadBand}
\title{Download the data regarding the broad band connection activation in Italian schools}
\source{
Broadband dashboard: <https://bandaultralarga.italia.it/scuole-voucher/dashboard-scuole/>
}
\usage{
Get_BroadBand(
  Date = as.Date(format(as.Date(format(Sys.Date(), "\%Y-\%m-01")) - 1, "\%Y-\%m-01")),
  include_municipality_code = TRUE,
  input_School2mun = NULL,
  input_Registry = NULL,
  input_AdmUnNames = NULL,
  verbose = TRUE,
  autoAbort = FALSE
)
}
\arguments{
\item{Date}{Object of class \code{Date}. The date at which it is required
to determine if the broad band connection has been activated or not.
By default, the first day of last month, which we assume to be the last update of the dataset.}

\item{include_municipality_code}{Logical. Whether to include municipality codes.
\code{TRUE} by default.}

\item{input_School2mun}{Object of class \code{list} obtained with \code{\link{Get_School2mun}}.
If \code{include_municipality_code == TRUE}, the mapping from school codes to municipality (and province) codes.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{input_Registry}{If \code{input_School2mun} is required, an object of class \code{tbl_df}, \code{tbl} and \code{data.frame}
corresponding to the national school registry (preferably of the last year, i.e. 2024/2025) obtained with \code{\link{Get_Registry}}. NULL by default.}

\item{input_AdmUnNames}{If \code{input_School2mun} is required, an object of class \code{tbl_df}, \code{tbl} and \code{data.frame}
corresponding to the statistical codes of administrative units (preferably referring to the period corresponding to school year 2024/2025)
 obtained with \code{\link{Get_AdmUnNames}}. NULL by default.}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{autoAbort}{Logical. Whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
 The variables \code{BB_Activation_date} and \code{BB_Activation_staus} indicate
 the activation date and activation status of the broadband connection at the selected date.
}
\description{
Retrieves the data regarding the activation date of the ultra-broadband connection in schools
and indicates whether the connection was activated or not at a certain date.
}
\details{
Ultra - Broadband is defined as everlasting internet connection with a
maximum speed of 1 gigabit per second, with a minimum guaranteed speed of
100 megabits/second both on the uploading and downloading operations, until
the peering point is reached, as declared on the data provider's website:
<https://bandaultralarga.italia.it/scuole-voucher/progetto-scuole/>.
In the example the broadband availability at the beginning of school  year 2022/23 (1st september 2022) is shown.
}
\examples{

\donttest{

  Broadband_220901 <- Get_BroadBand(Date = as.Date("2022-09-01"), autoAbort = TRUE)

  Broadband_220901

  Broadband_220901[, c(9,6,13,14)]

}




}
