% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampsd.R
\name{sampsd}
\alias{sampsd}
\title{Sampling Simulated Data and Estimation of Multivariate Standard Errors}
\usage{
sampsd(dat.sim, Par, transformation, method, n, m, k)
}
\arguments{
\item{dat.sim}{A list of simulated data sets generated by \code{\link{simdata}}.}

\item{Par}{A list of parameters estimated by \code{\link{assempar}}.}

\item{transformation}{Mathematical transformation to reduce the influence of dominant species: one of "square root", "fourth root", "Log (X+1)", "P/A", or "none".}

\item{method}{Dissimilarity metric to use, passed to \code{\link[vegan]{vegdist}} (e.g., "bray", "jaccard", "gower").}

\item{n}{Maximum number of sampling units per site (must be <= total units available).}

\item{m}{Maximum number of sites to sample per data set (must be <= total number of sites).}

\item{k}{Number of repetitions of each sampling configuration (samples × sites) for each data set.}
}
\value{
A matrix containing the estimated MultSE values for each simulated data set, sampling effort combination,
and repetition. This matrix is used by \code{\link{summary_ssp}}.
}
\description{
For each simulated data set, this function performs repeated sampling across a range of effort levels
and estimates the corresponding MultSE (pseudo-multivariate standard error) using dissimilarity-based methods.
}
\details{
For multi-site simulations, the function selects subsets of sites (from 2 to \code{m}) and then draws \code{n} samples per site
using a two-stage sampling method with inclusion probabilities (Tillé, 2006). For single-site simulations, repeated samples of size
2 to \code{n} are taken without replacement.

Each sample undergoes the selected transformation and a dissimilarity matrix is computed.
MultSE is estimated using:
\itemize{
  \item \emph{Single site:} pseudo-variance, with \eqn{MultSE = \sqrt(V/n)}
  \item \emph{Multiple sites:} mean squares from a PERMANOVA model (residual and site effects)
}
This procedure is computationally intensive, especially with large \code{k}. Start with low values for exploration.
}
\note{
For quick exploratory analysis, use small \code{k}. Once optimal sampling effort is explored,
rerun with larger \code{k} (e.g. 100). Computation time will increase accordingly.
}
\examples{
## Single site example
data(micromollusk)
par.mic <- assempar(data = micromollusk, type = "P/A", Sest.method = "average")
sim.mic <- simdata(par.mic, cases = 2, N = 20, sites = 1)
sam.mic <- sampsd(dat.sim = sim.mic, Par = par.mic, transformation = "P/A",
                  method = "jaccard", n = 10, m = 1, k = 3)

## For a multiple-site example, see the vignette

}
\references{
Anderson, M. J., & Santana-Garcon, J. (2015). Measures of precision for dissimilarity-based multivariate analysis of ecological communities. Ecology Letters, 18(1), 66–73.

Guerra-Castro, E. J., Cajas, J. C., Simoes, N., Cruz-Motta, J. J., & Mascaro, M. (2021). SSP: An R package to estimate sampling effort in studies of ecological communities. Ecography, 44(4), 561–573. \doi{10.1111/ecog.05284}

Tillé, Y. (2006). Sampling Algorithms. Springer, New York.
}
\seealso{
\code{\link{assempar}}, \code{\link{simdata}}, \code{\link{summary_ssp}}, \code{\link[vegan]{vegdist}}
}
