% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{is.historical}
\alias{is.historical}
\title{Checks if table contains historical data}
\usage{
is.historical(.data)
}
\arguments{
\item{.data}{(\code{data.frame(1)}, \code{tibble(1)}, \code{data.table(1)}, or \code{tbl_dbi(1)})\cr
Data object.}
}
\value{
\code{TRUE} if \code{.data} contains the columns: "checksum", "from_ts", and "until_ts". \code{FALSE} otherwise.
}
\description{
Checks if table contains historical data
}
\examples{
\dontshow{if (requireNamespace("RSQLite", quietly = TRUE)) withAutoprint(\{ # examplesIf}
  conn <- get_connection()

  dplyr::copy_to(conn, mtcars, name = "mtcars", temporary = FALSE)
  create_table(mtcars, conn, db_table = id("mtcars_historical", conn))

  is.historical(get_table(conn, "mtcars")) # FALSE
  is.historical(get_table(conn, "mtcars_historical")) # TRUE

  close_connection(conn)
\dontshow{\}) # examplesIf}
}
