% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_params_doc.R
\name{shared_params}
\alias{shared_params}
\title{shared params}
\arguments{
\item{data}{the data to fit as a data frame.  The output variables must be grouped AFTER the input variables}

\item{engine}{the fuzzy coco fit engine to use, one of \strong{rcpp} and \strong{hybrid}}

\item{formula}{the fuzzy coco model as a formula}

\item{fuzzy_system_desc}{a fuzzy system description as a named list}

\item{max_generations}{The maximum number of iterations of the algorithm.
Each iteration produces a new generation of the rules and membership functions populations.}

\item{max_fitness}{a stop condition: the iterations stop as soon as a generated fuzzy system fitness
reaches that threshold.}

\item{mode}{the type of model, either \strong{classification} or \strong{regression}}

\item{model}{a Fuzzy Coco model as a \code{fuzzy_coco} object}

\item{params}{fuzzy coco parameters, as a recursive named list, cf \code{\link[=params]{params()}}}

\item{progress}{whether to display the computation progress (using progressr, if available)}

\item{seed}{the RNG seed to use (to fit the model)}

\item{until}{function that takes an \code{engine} and returns TRUE if and only if the evolution must stop.
It is a way for the user to customize the stop conditions of the algorithm.}

\item{verbose}{whether to be verbose}

\item{x}{the input variables data (usually to fit) as a dataframe}

\item{y}{the output variables data (usually to fit)  as a dataframe}
}
\description{
shared params
}
\keyword{internal}
