% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{predict.encode}
\alias{predict.encode}
\title{Predict Spectral Embeddings}
\usage{
\method{predict}{encode}(object, rf, x, parallel = TRUE, ...)
}
\arguments{
\item{object}{Spectral embedding for the \code{rf} learned via \code{eigenmap}.}

\item{rf}{Pre-trained random forest object of class \code{ranger}.}

\item{x}{Data to be embedded.}

\item{parallel}{Compute in parallel? Must register backend beforehand, e.g.
via \code{doParallel}.}

\item{...}{Additional arguments passed to methods.}
}
\value{
A matrix of embeddings, with \code{nrow(x)} rows and \code{k} columns, the
latter argument used to learn the \code{eigenmap}.
}
\description{
Projects test data into the forest embedding space using a pre-trained
encoding map.
}
\details{
This function uses the weights learned via \code{eigenmap} to project new
data into the low-dimensional embedding space using the Nyström formula.
For details, see Bengio et al. (2004).
}
\examples{
# Set seed
set.seed(1)

# Split training and test
trn <- sample(1:nrow(iris), 100)
tst <- setdiff(1:nrow(iris), trn)

# Train RF. You can also use RF variants, such as the Adversarial Random
# Forests (ARF).
rf <- ranger::ranger(Species ~ ., data = iris[trn, ], num.trees=50)

# Learn the encodings, which are found using diffusion maps.
emap <- encode(rf, iris[trn, ], k=2)

# Embed test points
emb <- predict(emap, rf, iris[tst, ])


}
\references{
Bengio, Y., Delalleau, O., Le Roux, N., Paiement, J., Vincent, P., & Ouimet,
M. (2004). Learning eigenfunctions links spectral embedding and kernel PCA.
\emph{Neural Computation, 16}(10): 2197-2219.
}
\seealso{
\code{\link[arf]{adversarial_rf}}
}
