% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/REMixed-package.R
\docType{package}
\name{REMixed-package}
\alias{REMixed}
\alias{REMixed-package}
\title{REMixed : Regularisation & Estimation for Mixed effects model}
\description{
Suppose that we have a differential system of equations containing variables \eqn{(S_{p})_{p\leq P}} and \eqn{R}, that depends on some parameters. We define a non-linear mixed effects model from this system depending on individual parameters \eqn{(\psi_i)_{i\leq N}} and \eqn{(\phi_i)_{i\leq N}} that defines the parameters from the structural model as individuals. The first part \eqn{(\psi_i)_{i\leq N}} is supposed to derived from a generalized linear model for each parameter \eqn{l\leq m} :  \deqn{h_l(\psi_{li}) = h_l(\psi_{l pop})+X_i\beta_l + \eta_{li}} with the covariates of individual \eqn{i\leq N}, \eqn{(X_i)_{i\leq N}}, random effects \eqn{\eta_i=(\eta_{li})_{l\leq m}\overset{iid}{\sim}\mathcal{N}(0,\Omega)}, the population parameters \eqn{\psi_{pop}=(\psi_{lpop})_{l\leq m}}  and \eqn{\beta=(\beta_l)_{l\leq m_{re}}} is the vector of covariates effects on parameters. The rest of the population parameters of the structural model, that hasn't random effetcs, are denoted by \eqn{(\phi_i)_{i\leq N}}, and are defined, for each parameters \eqn{l\leq m_{no re}}  as \deqn{f_l(\phi_{li})=\phi_{l pop} + X_i \gamma_l } \cr To simplify formula, we write the individual process over the time, resulting from the differential system for a set of parameters \eqn{\phi_i = (\phi_{li})_{l\leq m_{no re}}, \psi_i = (\psi_{li})_{l\leq m_{re}}} for individual \eqn{i\leq N}, as \eqn{S_{p}(\cdot,\phi_i,\psi_i)=S_{pi}(\cdot)}, \eqn{p\leq P} and \eqn{R(\cdot,\phi_i,\psi_i)=R_i(\cdot)}. We assume that individual trajectories \eqn{(S_{pi})_{p\leq P,i\leq N}} are observed through a direct observation model, up to a transformation \eqn{g_p}, \eqn{p\leq P}, at differents times \eqn{(t_{pij})_{i\leq N,p\leq P,j\leq n_{ip}}} : \deqn{ Y_{pij}=g_p(S_{pi}(t_{pij}))+\epsilon_{pij} } with error \eqn{\epsilon_p=(\epsilon_{pij})\overset{iid}{\sim}\mathcal N(0,\varsigma_p^2)} for \eqn{p\leq P}. The individual trajectories \eqn{(R_{i})_{i\leq N}} are observed through $K$ latent processes, up to a transformation \eqn{s_k}, \eqn{k\leq K}, observed in \eqn{(t_{kij})_{k\leq K,i\leq N,j\leq n_{kij}}} : \deqn{Z_{kij}=\alpha_{k0}+\alpha_{k1} s_k(R_i(t_{kij}))+\varepsilon_{kij}} where \eqn{\varepsilon_k\overset{iid}{\sim} \mathcal N(0,\sigma_k^2)}. The parameters of the model are then \eqn{\theta=(\phi_{pop},\psi_{pop},B,\beta,\Omega,(\sigma^2_k)_{k\leq K},(\varsigma_p^2)_{p\leq P},(\alpha_{0k})_{k\leq K})} and \eqn{\alpha=(\alpha_{1k})_{k\leq K}}.
}
\author{
\strong{Maintainer}: Auriane Gabaut \email{aurianegabaut@gmail.com}

Authors:
\itemize{
  \item Ariane Bercu
  \item Mélanie Prague
  \item Cécile Proust-Lima
}

}
\keyword{internal}
