% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PopulationSettings.R
\name{createStudyPopulation}
\alias{createStudyPopulation}
\title{Create a study population}
\usage{
createStudyPopulation(
  plpData,
  outcomeId = plpData$metaData$databaseDetails$outcomeIds[1],
  populationSettings = createStudyPopulationSettings(),
  population = NULL
)
}
\arguments{
\item{plpData}{An object of type \code{plpData} as generated using
\code{getplpData}.}

\item{outcomeId}{The  ID of the outcome.}

\item{populationSettings}{An object of class populationSettings created using \code{createPopulationSettings}}

\item{population}{If specified, this population will be used as the starting point instead of the
cohorts in the \code{plpData} object.}
}
\value{
A data frame specifying the study population. This data frame will have the following columns:
\describe{
\item{rowId}{A unique identifier for an exposure}
\item{subjectId}{The person ID of the subject}
\item{cohortStartdate}{The index date}
\item{outcomeCount}{The number of outcomes observed during the risk window}
\item{timeAtRisk}{The number of days in the risk window}
\item{survivalTime}{The number of days until either the outcome or the end of the risk window}
}
}
\description{
Create a study population
}
\details{
Create a study population by enforcing certain inclusion and exclusion criteria, defining
a risk window, and determining which outcomes fall inside the risk window.
}
\examples{
\donttest{ \dontshow{ # takes too long } 
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 100, seed = 42)
# Create study population, require time at risk of 30 days. The risk window is 1 to 90 days.
populationSettings <- createStudyPopulationSettings(requireTimeAtRisk = TRUE,
                                                     minTimeAtRisk = 30,
                                                     riskWindowStart = 1,
                                                     riskWindowEnd = 90)
population <- createStudyPopulation(plpData, outcomeId = 3, populationSettings)
}
}
