% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnc.R
\name{pnc}
\alias{pnc}
\title{Analyze Phylogenetic Niche Conservatism in Ecological Communities}
\usage{
pnc(
  trait_data,
  phylo_tree,
  methods = "lambda",
  pca_axes = c("PC1", "PC2"),
  sig_levels = c(0.001, 0.01, 0.05),
  nsim = 1000,
  verbose = TRUE
)
}
\arguments{
\item{trait_data}{A data frame or matrix containing trait data with species as rows}

\item{phylo_tree}{A phylogenetic tree object of class "phylo"}

\item{methods}{Character vector specifying methods to use. Options: "lambda", "K"}

\item{pca_axes}{Character vector specifying which PCA axes to include (e.g., c("PC1", "PC2"))}

\item{sig_levels}{Numeric vector of significance levels for marking results}

\item{nsim}{Number of permutations for significance testing}

\item{verbose}{Logical indicating whether to show progress and warnings}
}
\value{
A data frame containing phylogenetic signal results
}
\description{
This function performs in-depth phylogenetic niche conservatism analysis for
communities by quantifying phylogenetic signal in trait data using multiple statistical methods.
The function integrates trait data preprocessing, phylogenetic tree manipulation,
optional principal component analysis, and robust statistical testing to provide detailed insights
into evolutionary constraints on trait evolution.
}
\examples{
\donttest{
#' # Load example data
data(BCI)
data(TRY)

# Extract trait data
sp <- colnames(BCI$com)
subtraits <- extract_traits(sp, TRY, rank = "species",
                            traits = c("LA", "LMA", "LeafN", "PlantHeight", "SeedMass", "SSD"))

# Calculate phylogenetic signal using Lambda method
pnc(subtraits, BCI$phy_species, methods = "lambda")

# Calculate without PCA analysis
pnc(subtraits, BCI$phy_species, methods = "lambda", pca_axes = NULL)
}

}
\references{
Münkemüller, T., Lavergne, S., Bzeznik, B., Dray, S., Jombart, T., Schiffers, K. and Thuiller, W. (2012).
How to measure and test phylogenetic signal. Methods in Ecology and Evolution, 3(4), 743-756.
\doi{10.1111/j.2041-210X.2012.00196.x}
}
