% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covtest.lc.R
\name{covtest.lc}
\alias{covtest.lc}
\title{Two-sample high-dimensional covariance test (Li and Chen, 2012)}
\usage{
covtest.lc(dataX,dataY)
}
\arguments{
\item{dataX}{an \eqn{n_1} by \eqn{p} data matrix}

\item{dataY}{an \eqn{n_2} by \eqn{p} data matrix}
}
\value{
\code{stat} the value of test statistic

\code{pval} the p-value for the test.
}
\description{
This function implements the two-sample \eqn{l_2}-norm-based high-dimensional covariance test
proposed by Li and Chen (2012).
Suppose \eqn{\{\mathbf{X}_1, \ldots, \mathbf{X}_{n_1}\}} are i.i.d.
copies of \eqn{\mathbf{X}}, and \eqn{\{\mathbf{Y}_1, \ldots, \mathbf{Y}_{n_2}\}}
are i.i.d. copies of \eqn{\mathbf{Y}}. The test statistic \eqn{T_{LC}} is
defined as
\deqn{T_{LC} = A_{n_1}+B_{n_2}-2C_{n_1,n_2},}
where \eqn{A_{n_1}}, \eqn{B_{n_2}}, and \eqn{C_{n_1,n_2}} are unbiased estimators for
\eqn{\mathrm{tr}(\mathbf{\Sigma}^2_1)}, \eqn{\mathrm{tr}(\mathbf{\Sigma}^2_2)},
and  \eqn{\mathrm{tr}(\mathbf{\Sigma}_1\mathbf{\Sigma}_2)}, respectively.
Under the null hypothesis \eqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the leading variance of \eqn{T_{LC}} is
\eqn{\sigma^2_{T_{LC}} = 4(\frac{1}{n_1}+\frac{1}{n_2})^2 \rm{tr}^2(\mathbf{\Sigma}^2)},
which can be consistently estimated by \eqn{\hat\sigma^2_{LC}}.
The explicit formulas of \eqn{A_{n_1}}, \eqn{B_{n_2}}, \eqn{C_{n_1,n_2}}
and \eqn{\hat\sigma^2_{T_{LC}}} can be found in
Equations (2.1), (2.2) and Theorem 1 of Li and Chen (2012).
With some regularity conditions, under the null hypothesis \eqn{H_{0c}: \mathbf{\Sigma}_1 = \mathbf{\Sigma}_2},
the test statistic \eqn{T_{LC}} converges in distribution to a standard normal distribution
as \eqn{n_1, n_2, p \rightarrow \infty}.
The asymptotic  \eqn{p}-value is obtained by
\deqn{p_{LC} = 1-\Phi(T_{LC}/\hat\sigma_{T_{LC}}),}
where \eqn{\Phi(\cdot)} is the cdf of the standard normal distribution.
}
\examples{
n1 = 100; n2 = 100; pp = 500
set.seed(1)
X = matrix(rnorm(n1*pp), nrow=n1, ncol=pp)
Y = matrix(rnorm(n2*pp), nrow=n2, ncol=pp)
covtest.lc(X,Y)
}
\references{
Li, J. and Chen, S. X. (2012). Two sample tests for high-dimensional
covariance matrices. \emph{The Annals of Statistics}, 40(2):908–940.
}
