% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PoissonExpPower.r
\name{PoissonExpPower}
\alias{PoissonExpPower}
\alias{dpois.exp.pow}
\alias{ppois.exp.pow}
\alias{qpois.exp.pow}
\alias{rpois.exp.pow}
\alias{hpois.exp.pow}
\title{Poisson Exponential Power Distribution}
\usage{
dpois.exp.pow(x, alpha, beta, lambda, log = FALSE)
ppois.exp.pow(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qpois.exp.pow(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rpois.exp.pow(n, alpha, beta, lambda)
hpois.exp.pow(x, alpha, beta, lambda)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{alpha}{positive numeric parameter}

\item{beta}{positive numeric parameter}

\item{lambda}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dpois.exp.pow}: numeric vector of (log-)densities
  \item \code{ppois.exp.pow}: numeric vector of probabilities
  \item \code{qpois.exp.pow}: numeric vector of quantiles
  \item \code{rpois.exp.pow}: numeric vector of random variates
  \item \code{hpois.exp.pow}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Poisson Exponential Power distribution.
}
\details{
The Poisson Exponential Power distribution is parameterized by the parameters
\eqn{\alpha > 0}, \eqn{\beta > 0}, and \eqn{\lambda > 0}.


The Poisson Exponential Power distribution has CDF:

\deqn{
F(x; \alpha, \beta, \lambda) =
\quad 1-\frac{1}{\left(1-e^{-\lambda}\right)}\left[1-\exp 
\left\{-\lambda \exp \left(1-e^{\beta x^\alpha}\right)\right\}\right]  \quad ;\;x > 0.
}

where \eqn{\alpha}, \eqn{\beta}, and \eqn{\lambda} are the parameters.

The following functions are included:
\itemize{
  \item \code{dpois.exp.pow()} — Density function
  \item \code{ppois.exp.pow()} — Distribution function
  \item \code{qpois.exp.pow()} — Quantile function
  \item \code{rpois.exp.pow()} — Random generation
  \item \code{hpois.exp.pow()} — Hazard function
}
}
\examples{
x <- seq(0.1, 2.0, 0.2)
dpois.exp.pow(x, 2.0, 0.5, 0.2)
ppois.exp.pow(x, 2.0, 0.5, 0.2)
qpois.exp.pow(0.5, 2.0, 0.5, 0.2)
rpois.exp.pow(10, 2.0, 0.5, 0.2)
hpois.exp.pow(x, 2.0, 0.5, 0.2)

# Data
x <- stress
# ML estimates
params = list(alpha=0.6976, beta=0.6395, lambda=7.8045)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = ppois.exp.pow, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qpois.exp.pow, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dpois.exp.pow, pfun=ppois.exp.pow, plot=TRUE)
print.gofic(out)

}
\references{
Joshi, R. K., & Kumar, V. (2020). 
Poisson Exponential Power distribution: Properties and Application.
\emph{International Journal of Mathematics & Computer Research},  
\bold{8(11)}, 2152--2158. \doi{10.47191/ijmcr/v8i11.01}
}
