% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ModInvLomax.r
\name{ModInvLomax}
\alias{ModInvLomax}
\alias{dmod.inv.lomax}
\alias{pmod.inv.lomax}
\alias{qmod.inv.lomax}
\alias{rmod.inv.lomax}
\alias{hmod.inv.lomax}
\title{Modified Inverse Lomax (MIL) Distribution}
\usage{
dmod.inv.lomax(x, alpha, beta, lambda, log = FALSE)
pmod.inv.lomax(q, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
qmod.inv.lomax(p, alpha, beta, lambda, lower.tail = TRUE, log.p = FALSE)
rmod.inv.lomax(n, alpha, beta, lambda)
hmod.inv.lomax(x, alpha, beta, lambda)
}
\arguments{
\item{x}{numeric vector of strictly positive quantiles.}

\item{alpha}{positive shape parameter.}

\item{beta}{positive scale parameter.}

\item{lambda}{positive shape/scale parameter.}

\item{log}{logical; if \code{TRUE}, returns the log-density.}

\item{q}{numeric vector of strictly positive quantiles.}

\item{lower.tail}{logical; if \code{TRUE} (default), probabilities are
\eqn{P(X \le x)}, otherwise \eqn{P(X > x)}.}

\item{log.p}{logical; if \code{TRUE}, probabilities are returned as \code{log(p)}.}

\item{p}{numeric vector of probabilities with values in (0, 1).}

\item{n}{number of observations (positive integer).}
}
\value{
\itemize{
  \item \code{dmod.inv.lomax}: numeric vector of (log) densities.
  \item \code{pmod.inv.lomax}: numeric vector of distribution function values.
  \item \code{qmod.inv.lomax}: numeric vector of quantiles.
  \item \code{rmod.inv.lomax}: numeric vector of random variates.
  \item \code{hmod.inv.lomax}: numeric vector of hazard rates.
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the Modified Inverse Lomax distribution.
}
\details{
The distribution is parameterized by shape parameters
\eqn{\alpha > 0}, \eqn{\beta > 0} and scale/shape parameter
\eqn{\lambda > 0}.


The cumulative distribution function (CDF) of the MIL distribution is

\deqn{
F(x; \alpha,\beta,\lambda) =
\left[1+\left(\frac{\beta}{x}\right)e^{-\lambda x}\right]^{-\alpha},
\quad x>0.
}
}
\examples{
x <- seq(0.1, 5, by = 0.1)
dmod.inv.lomax(x, alpha = 1.5, beta = 2, lambda = 0.5)
pmod.inv.lomax(x, alpha = 1.5, beta = 2, lambda = 0.5)
qmod.inv.lomax(0.5, alpha = 1.5, beta = 2, lambda = 0.5)
set.seed(123)
rmod.inv.lomax(5, alpha = 1.5, beta = 2, lambda = 0.5)
hmod.inv.lomax(x, alpha = 1.5, beta = 2, lambda = 0.5)

# Data
x <- windshield
# ML estimates
params = list(alpha=0.6661, beta=26.8875, lambda=1.0004)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pmod.inv.lomax, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qmod.inv.lomax, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dmod.inv.lomax, pfun=pmod.inv.lomax, plot=FALSE)
print.gofic(out)

}
\references{
Telee, L.B.S., Yadav, R.S., & Kumar V.(2023). 
Modified Inverse Lomax Distribution: Model and properties. 
\emph{Discovery}, \bold{59: e110d1352}. 
\doi{10.54905/disssi.v59i333.e110d1352}
}
