% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NdfF.R
\name{NdfF}
\alias{NdfF}
\title{Calculate N derived from Fertilizer (NdfF)}
\usage{
NdfF(Plant15N, Fert15N)
}
\arguments{
\item{Plant15N}{A vector of 15N atom percent excess in plant or soil.}

\item{Fert15N}{15N atom percent excess of fertilizer N.}
}
\value{
A numeric vector of NdfF percentages.
}
\description{
The percentage of plant or soil N that is derived from the fertilizer.
Formula: NdfF = (Plant15N / Fert15N) * 100
}
\examples{
Plant15N <- c(0.4, 0.5)
Fert15N <- 2.5
NdfF(Plant15N, Fert15N)
}
