% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{analyze_pca_variable_importance_general}
\alias{analyze_pca_variable_importance_general}
\title{Analyze and Visualize PCA Variable Importance}
\usage{
analyze_pca_variable_importance_general(
  pca_result = NULL,
  output_dir = tempdir(),
  experiment_name = "PCA_Analysis",
  pc_x = "PC1",
  pc_y = "PC2",
  color_scheme = "default",
  top_n = 15,
  min_loading_threshold = 0.1,
  save_plots = TRUE,
  show_labels = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{pca_result}{A PCA result object. Can be either a \code{prcomp} object directly, or a list
containing a PCA object in fields named 'pca_result', 'pca', 'result', or 'prcomp'.}

\item{output_dir}{Character string specifying the directory for saving plots and results (default: "pca_plots").}

\item{experiment_name}{Character string used as a prefix for output files and plot titles (default: "PCA_Analysis").}

\item{pc_x}{Character string specifying the principal component for x-axis analysis (default: "PC1").}

\item{pc_y}{Character string specifying the principal component for y-axis analysis (default: "PC2").}

\item{color_scheme}{Character string specifying the color palette. Options: "default", "viridis", "colorbrewer" (default: "default").}

\item{top_n}{Numeric value specifying the number of top variables to focus on in detailed analyses (default: 15).}

\item{min_loading_threshold}{Numeric value specifying the minimum loading threshold for importance filtering (default: 0.1).}

\item{save_plots}{Logical indicating whether to save plots and results to disk (default: TRUE).}

\item{show_labels}{Logical indicating whether to show variable labels on the biplot (default: TRUE).}

\item{verbose}{Logical indicating whether to print detailed progress messages (default: TRUE).}
}
\value{
A list containing:
\describe{
  \item{plots}{Named list of ggplot objects: 'biplot', 'importance_bar', 'pc_comparison', 'heatmap'}
  \item{variable_importance}{Data frame with comprehensive variable importance metrics for all variables}
  \item{selected_variables}{Data frame containing the top N most important variables with detailed statistics}
  \item{analysis_summary}{List with key analysis metrics and variance explained information}
  \item{config_used}{List documenting all parameters used in the analysis}
}
}
\description{
This function performs comprehensive analysis of variable importance in Principal Component Analysis,
generating multiple visualization types including loading biplots, importance rankings, PC comparisons,
and heatmaps. It extracts variable contributions to specified principal components and creates
publication-ready plots with detailed statistical summaries.
}
\details{
The function calculates multiple importance metrics for each variable:
\itemize{
  \item \strong{PC loadings}: Direct loading values for specified principal components
  \item \strong{Combined importance}: Euclidean distance combining both PC loadings
  \item \strong{Contribution percentages}: Percent contribution to each PC's total variance
  \item \strong{Ranking}: Variables ranked by combined importance score
}

Four visualization types are generated:
\itemize{
  \item \strong{Loading Biplot}: Scatter plot showing variable loadings on both PCs with size indicating importance
  \item \strong{Importance Bar Chart}: Ranked bar chart of top variables by combined importance
  \item \strong{PC Comparison}: Side-by-side comparison of absolute loadings for both PCs
  \item \strong{Loading Heatmap}: Color-coded matrix showing loading values and directions
}

The function automatically:
\itemize{
  \item Validates input PCA objects from various sources
  \item Calculates variance explained by each principal component
  \item Creates publication-ready plots with consistent theming
  \item Exports detailed CSV files with variable rankings and analysis summaries
  \item Provides comprehensive statistical summaries
}

Color schemes provide different aesthetic options:
\itemize{
  \item \code{default}: Blue/red palette suitable for most publications
  \item \code{viridis}: Colorblind-friendly viridis color scale
  \item \code{colorbrewer}: ColorBrewer palettes optimized for scientific visualization
}

View top variables using head(results$selected_variables)
}
\section{Output Files}{

When \code{save_plots = TRUE}, the function creates files in the specified
output directory (default: "pca_plots"). For CRAN compliance, use \code{tempdir()}
for the output directory:
\itemize{
  \item PNG files for each visualization type
  \item CSV file with complete variable importance rankings
  \item CSV file with selected top variables and detailed metrics
  \item CSV file with analysis summary and metadata
}
}

\seealso{
\code{\link{prcomp}} for PCA computation, \code{\link{biplot}} for basic PCA plotting
}
