#' JAGS model: Fixed-Effects (FE)
#'
#' A single-length character string containing the JAGS model for the
#' fixed-effects specification, per same setting as in the NMAP paper.
#'
#' @format A length-1 character vector.
#' @examples
#' # JAGS (text connection works)
#' if (requireNamespace("rjags", quietly = TRUE)) {
#'   m <- rjags::jags.model(textConnection(jags_model_FE), data = list())
#' }
#' @docType data
#' @name jags_model_FE
#' @usage data(jags_model_FE)
#' @keywords datasets
NULL

#' JAGS model: Random-Effects (RE)
#'
#' A single-length character string containing the JAGS model for the
#' random-effects specification, per same setting as in the NMAP paper
#'
#' @format A length-1 character vector.
#' @examples
#' if (requireNamespace("rjags", quietly = TRUE)) {
#'   m <- rjags::jags.model(textConnection(jags_model_RE), data = list())
#' }
#' @docType data
#' @name jags_model_RE
#' @usage data(jags_model_RE)
#' @keywords datasets
NULL