% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotModel.R
\name{PlotModel}
\alias{PlotModel}
\title{Funcao obtencao de graficos associados ao ajuste do modelo}
\usage{
PlotModel(object,plot=3)
}
\arguments{
\item{object}{Objeto criado pela funcao `FitModel`}

\item{plot}{valor numerico indicando o grafico desejado, pode ser:
  \itemize{
\item plot=1 -> Residuals vs Fitted.
\item plot=2 -> QQ-plot dos residuos.
\item plot=3 -> Histograma dos residuos.
\item plot=4 -> Grafico com o ajuste dos valores observados com os preditos.
  }}
}
\value{
A funcao retorna graficos sobre o ajuste do modelo regressao.
}
\description{
Esta funcao plota graficos importantes associados ao modelo ajustado.
}
\examples{
data("DadosPalma")
X=DadosPalma[,-7]
Y=DadosPalma[,7]
model=CreateModel(X,Intercept = TRUE, Simple =TRUE, InteractionLL = TRUE)
model
Ajust=FitModel(X,Y,Model=model)
Ajust
PlotModel(Ajust,plot=1)
PlotModel(Ajust,plot=2)
PlotModel(Ajust,plot=3)
PlotModel(Ajust,plot=4)

}
\references{
Tutoriais onlines:
https://www.youtube.com/channel/UCDGyvLCJnv9RtTY1YMBMVNQ
}
\seealso{
\code{\link{FitModel}}, \code{\link{CreateModel}}, \code{\link{PredictModel}}
}
