% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{MultiRFM}
\alias{MultiRFM}
\title{Fit the high-dimensional multi-study robust factor model}
\usage{
MultiRFM(
  XList,
  q = 15,
  qs = rep(2, length(XList)),
  epsELBO = 1e-05,
  maxIter = 30,
  verbose = TRUE,
  seed = 1
)
}
\arguments{
\item{XList}{A length-M list, where each component represents a matrix and is the}

\item{q}{an optional integer, specify the number of study-shared factors; default as 15.}

\item{qs}{a integer vector with length M, specify the number of study-specifed factors; default as 2.}

\item{epsELBO}{an optional positive vlaue, tolerance of relative variation rate of the envidence lower bound value, defualt as '1e-5'.}

\item{maxIter}{the maximum iteration of the VEM algorithm. The default is 30.}

\item{verbose}{a logical value, whether output the information in iteration.}

\item{seed}{an optional integer, specify the random seed for reproducibility in initialization;default as 1.}
}
\value{
return a list including the following components:(1) F, a list composed by the posterior estimation of study-shared factor matrix for each study; (2) H,  a list composed by the posterior estimation of study-specified factor matrix for each study;
(3) Sf, a list consisting of the posterior estimation of covariance matrix of study-shared factors for each study; (4) Sh, a list consisting of the posterior estimation of covariance matrix of study-specified factors for each study;
(5) A, the loading matrix corresponding to study-shared factors; (6) B, a list composed by the loading matrices corresponding to the study-specified factors;
(7) mu,the mean of XList;(8) ELBO: the ELBO value when algorithm stops; (9) ELBO_seq: the sequence of ELBO values.
(10) time_use, the elapsed time for model fitting.
}
\description{
Fit the high-dimensional multi-study robust factor model which learns latent features and accounts for the heterogeneity among source.
}
\details{
None
}
\examples{
p <- 100
nvec <- c(150,200); qs <- c(2,2)
datList <- gendata_simu_multi(seed=1, nvec=nvec, p=p, q=3, qs=qs, rho=c(5,5),
        err.type='mvt', sigma2_eps = 1, nu=3)
XList <- datList$Xlist;
res <- MultiRFM(XList, q=3, qs= qs)
str(res)
}
