% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Input_floads.R
\name{loading.value}
\alias{loading.value}
\title{Specifies Factor Loading Values for a Model.}
\usage{
loading.value(nf, fl.loads)
}
\arguments{
\item{nf}{An integer specifying the number of factors.}

\item{fl.loads}{A numeric vector of factor loadings. Values should be provided in column-wise order, corresponding to the items loading on each factor.}
}
\value{
The function returns the factor loading matrix.
}
\description{
This function creates a factor loading matrix for a given Structural Equation Model (SEM).
The loadings must be provided as a vector and are assigned to the matrix column by column, where each column corresponds to a latent factor and each row corresponds to an observed item.
All factor loadings must be specified as values strictly greater than 0 and less than 1.
The resulting matrix has dimensions equal to the number of items by the number of factors.
}
\examples{
# This example represents a three-factor CFA model
#  where the factors are indicated by 3, 3, and 2 items respectively.
#
loading.value(nf=3, fl.loads=c(.6,.6,.6,0,0,0,0,0,0,0,0,.7,.7,.7,0,0,0,0,0,0,0,0,.8,.8))
}
\author{
Fatih Orçan
}
