% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{recalc.nnfit.from.map}
\alias{recalc.nnfit.from.map}
\title{Calculate a nearest neighbour fit from an estimated map object.}
\usage{
recalc.nnfit.from.map(estmap, mapobject, header = TRUE)
}
\arguments{
\item{estmap}{A character string indicating the name of a comma separated value 
file with  the first column containing marker names in the order of their estimated position.}

\item{mapobject}{A map object generated by \code{\link{calc.maps.pc}}, 
\code{\link{calc.maps.sphere}} or \code{\link{estimate.map}}.}

\item{header}{Logical argument indicating whether the .csv file \code{estmap} 
contains headers - default is \code{TRUE}}
}
\value{
A list with the elements:
\item{fit}{Sum over all markers of the nearest neighbour fits.}
\item{pointfits}{The nearest neighbour fit for each marker.}
\item{meanfit}{Meanv of the nearest neighbour fits over all markers.}
}
\description{
Calculates a new nearest neighbour fit based on a new order from a map object 
generated by \code{\link{calc.maps.pc}}, \code{\link{calc.maps.sphere}} or 
\code{\link{estimate.map}}
}
\details{
Reads in a new estimated order, reorders the distance map and LOD scores by 
the new order and recalculates the nearest neighbour fit.
}
\seealso{
\code{\link{calc.maps.pc}}, \code{\link{calc.maps.sphere}}, \code{\link{estimate.map}}, \code{\link{calc.nnfit}}
}
