LSMfit=function(X,ndim_z,penalty=NULL,C=NULL,starts=NULL,tol=.1e-2,silent=FALSE){
  if((!is.null(penalty))&(!is.null(C))) warning("you are combining the penalized and constraint approaches which is possible in principle, but may cause unexpected model behaviour.")
  if(is.null(penalty)&is.null(C)){
    penalty=1
    C=0
  }
  if(is.null(penalty)&(!is.null(C))){
    penalty=-1
    if(C<=0) stop("C should larger than 0")
  }
  if((!is.null(penalty))&is.null(C)) C=0
  if(!is.matrix(X)) stop("X should be a matrix")
  N=nrow(X)
  nit=nit0=ncol(X)
  if(!all(apply(X,2,min,na.rm=TRUE)==rep(0,nit))) stop("data should be coded so that the lowest score is 0 for each item")
  nc=apply(X,2,max,na.rm=TRUE)+1
  if(!all(nc==rep(2,nit))) GRM=TRUE else GRM=FALSE

  J=matrix(0,nit0,sum(nc-1))
  for(i in 1:nit0)
    for(c in 1:(nc[i]-1)){
      if(i==1) J[i,c]=1
      if(i>1) J[i,sum(nc[1:(i-1)]-1)+c]=1
    }
  J0=matrix(0,nit0,sum(nc-1))
  for(i in 1:nit0){
      if(i==1) J0[i,1]=1
      if(i>1) J0[i,sum(nc[1:(i-1)]-1)+1]=1
    }
  t0=Sys.time()

  if(!is.list(starts)){
    if(is.null(starts)) starts0=LSMstartsML(X,ndim_z,J,nc,random=FALSE, silent=silent)
    else {
      if(starts=="wls") starts0=LSMstarts(X,ndim_z,J,nc,random=FALSE, silent=silent)
      if(starts=="ml") starts0=LSMstartsML(X,ndim_z,J,nc,random=FALSE, silent=silent)
      if(starts=="random") starts0=LSMstarts(X,ndim_z,J,nc,random=TRUE, silent=silent)
    }
  } else if(is.list(starts)) starts0=starts

  z0=c()
  w0=c()
  for(s in 1:ndim_z){
    z0=cbind(z0,-1,starts0$z0[,s])
    w0=cbind(w0,starts0$w0[,s],1)
  }
  theta0=cbind(1,starts0$theta0)
  b0=cbind(starts0$b0,1)
  if(ndim_z==0){
    z0=cbind(-1,matrix(0,N))
    w0=cbind(matrix(0,nit),1)
  }

  if(GRM){
    X2=matrix(,N,sum(nc-1))
    dummy0=dummy1=rep(0,max(nc-1))
    for(p in 1:N)
      for(i in 1:nit)
        if(!is.na(X[p,i])){
            dummy1=dummy0[1:(nc[i]-1)]
            if(X[p,i]>0) dummy1[seq(1,X[p,i])]=1
            if(i>1) X2[p,(sum(nc[1:(i-1)]-1)+1):(sum(nc[1:i]-1))]=dummy1
            if(i==1) X2[p,1:(nc[i]-1)]=dummy1
          }
    nit0=ncol(X)
    nit=ncol(X2)
    X=X2
    w0=t(J)%*%w0
  }

  U=(!is.na(X))*1
  X[is.na(X)]=0

  if(C==0) resLSM=(fitModel(theta0, b0, z0,w0,ndim_z,penalty,C,X,U,J,J0,N,nit,nit0,nc,tol=tol,silent=silent))
  if(C!=0) resLSM=(fitModel_C(theta0, b0, z0,w0,ndim_z,penalty,C,X,U,J,J0,N,nit,nit0,nc,tol=tol,silent=silent))
  time=Sys.time()-t0
  if(ndim_z>0){
    z=resLSM$z[,seq(2,ndim_z*2,2)]
    w=resLSM$w[,seq(1,ndim_z*2,2)]
  }
  if(ndim_z==0){
    z=matrix(0,N)
    w=matrix(0,nit)
  }
  if(GRM) w=J0%*%w
  if(silent==FALSE) cat("Time taken:",time,units(time),"\n")

  as_starts=list(theta0=matrix(resLSM$theta[,2]),b0=matrix(resLSM$b[,1]),z0=as.matrix(z),w0=as.matrix(w))


  results=list(theta=matrix(resLSM$theta[,2]),b=matrix(resLSM$b[,1]),z=as.matrix(z),w=as.matrix(w),logL=resLSM$logLik,
              internal=list(theta=resLSM$theta,b=resLSM$b,z=resLSM$z,w=resLSM$w,
                            ndim_z=ndim_z,penalty=penalty, C=C,
                            X=X,U=U,J=J,J0=J0,N=N,nit=nit,nit0=nit0,nc=nc,tol=tol),
              starts=starts0,as_starts=as_starts)

  class(results)<-"LSMfit"
  return(results)
}
