% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpfunctions.R
\name{get_datlvls}
\alias{get_datlvls}
\title{Determine grouping level of data}
\usage{
get_datlvls(data, groups_df)
}
\arguments{
\item{data}{a \code{data.frame}}

\item{groups_df}{the \code{data.frame} of (integer) grouping vectors of length
\code{nrow(data)}.}
}
\value{
A named character vector of length \code{ncol(data)}. Each element is the
name of the grouping level at which the corresponding data column is
constant.
}
\description{
For each column in a \code{data.frame}-like object, identify the hierarchical
level as the highest grouping level from \code{groups_df} for which the column is
identical for all members of every group.
}
\seealso{
\code{get_grouping_levels}
}
\keyword{internal}
