% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_MIdat.R
\name{get_MIdat}
\alias{get_MIdat}
\title{Extract multiple imputed datasets from an object of class JointAI}
\usage{
get_MIdat(object, m = 10, include = TRUE, start = NULL, minspace = 50,
  seed = NULL, export_to_SPSS = FALSE, resdir = NULL, filename = NULL)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{m}{number of imputed datasets}

\item{include}{should the original, incomplete data be included? Default is
\code{TRUE}.}

\item{start}{the first iteration of interest
(see \code{\link[coda]{window.mcmc}})}

\item{minspace}{minimum number of iterations between iterations to be chosen
as imputed values (to prevent strong correlation between
imputed datasets in the case of high autocorrelation of the
MCMC chains).}

\item{seed}{optional seed value}

\item{export_to_SPSS}{logical; should the completed data be exported to SPSS?}

\item{resdir}{optional; directory for results. If unspecified and
\code{export_to_SPSS = TRUE} the current working directory is
used.}

\item{filename}{optional; file name (without ending). If unspecified and
\code{export_to_SPSS = TRUE} a name is generated
automatically.}
}
\value{
A \code{data.frame} in which the original data (if
\code{include = TRUE}) and the imputed datasets are stacked onto
each other.\cr
The variable \code{Imputation_} indexes the imputation, while
\code{.rownr} links the rows to the rows of the original data.
In cross-sectional datasets the
variable \code{.id} is added as subject identifier.
}
\description{
This function returns a dataset containing multiple imputed datasets stacked
onto each other (i.e., long format; optionally including the original,
incomplete data).\cr
These data can be automatically exported to SPSS (as a .txt file containing
the data and a .sps file containing syntax to generate a .sav file).
For the export function the
\href{https://CRAN.R-project.org/package=foreign}{\strong{foreign}} package
needs to be installed.
}
\section{Note}{

In order to be able to extract (multiple) imputed datasets the imputed values
must have been monitored, i.e., \code{imps = TRUE} had to be specified in the
argument \code{monitor_params} in \code{\link[JointAI:model_imp]{*_imp}}.
}

\examples{

\dontrun{
# fit a model and monitor the imputed values with
# monitor_params = c(imps = TRUE)

mod <- lm_imp(y ~ C1 + C2 + M2, data = wideDF,
              monitor_params = c(imps = TRUE), n.iter = 100)

# Example 1: without export to SPSS
MIs <- get_MIdat(mod, m = 3, seed = 123)



# Example 2: with export for SPSS
# (here: to the temporary directory "temp_dir")

temp_dir <- tempdir()
MIs <- get_MIdat(mod, m = 3, seed = 123, resdir = temp_dir,
                 filename = "example_imputation",
                 export_to_SPSS = TRUE)

}

}
\seealso{
\code{\link{plot_imp_distr}}
}
