
#'
#' PCLR_Test
#' 
#' PCR_Train is the test set of the PCR model. It consists of Age, Cluster1, 
#' MeanDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole 
#' and MeanDNE.Convex. The number of rows is 191.
#' 
#' @export
#' 
PCLR_Test<-{
  Age <- c(21, 77, 56, 68, 67, 33, 76, 86, 68, 72, 20, 60, 69, 68, 32, 80, 48, 76, 47, 77, 39, 28, 55, 38, 79, 22, 25, 25, 86, 94, 20, 69, 32, 69, 25, 63, 45, 67, 20, 22, 76, 46, 37, 48, 44, 44, 80, 85, 49, 40, 59, 78, 20, 61, 61, 43, 52, 66, 50, 42, 57, 70, 69, 50, 84, 65, 77, 70, 75, 53, 60, 52, 69, 31, 78, 43, 43, 54, 44, 75, 58, 75, 52, 82, 57, 65, 51, 67, 65, 68, 
           72, 52, 54, 51, 51, 59, 65, 56, 51, 56, 68, 50, 63, 63, 62, 68, 52, 52, 50, 62, 52, 55, 31, 31, 53, 35, 22, 49, 62, 49, 35, 30, 46, 25, 25, 67, 64, 64, 60, 49, 33, 34, 68, 48, 68, 67, 24, 92, 43, 30, 30, 49, 60, 68, 68, 47, 95, 81, 88, 49, 61, 85, 42, 76, 79, 45, 74, 44, 68, 62, 92, 56, 72, 83, 62, 88, 80, 67, 60, 83, 85, 85, 60, 78, 51, 63, 82, 39, 39, 86, 85, 61, 76, 82, 66, 70, 88, 93, 87, 55, 83)
  
  Cluster1 <-c(1, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 2, 1, 2, 2, 2, 2, 2, 1, 1, 1, 2, 1, 2, 1, 1, 1, 1, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 2, 2, 1, 1, 1, 1, 1, 2, 1, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
               1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 2, 1, 2, 2, 1, 2, 1, 1, 1, 1, 1, 2, 2, 1, 2, 2, 2, 1, 1, 2, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 2, 2, 1, 2, 2, 2, 1, 2, 2, 2, 1, 2, 1, 2, 2, 1, 1, 2, 2, 1, 2, 2, 1, 2, 2, 2, 2, 1, 2)
  
  MeanDNE.Apex <- c(0.029771, 0.042857, 0.033512, 0.042875, 0.036122, 0.028402, 0.037618, 0.041587, 0.043181, 0.031102, 0.025030, 0.030580, 0.036367, 0.037042, 0.028965, 0.033328, 0.037145, 0.044713, 0.034744, 0.042251, 0.026972, 0.023185, 0.034759, 0.030897, 0.038136, 0.022208, 0.020166, 0.027855, 0.039693, 0.048044, 0.029837, 0.030431, 0.040651, 0.040210, 0.032622, 0.038671, 0.030966, 0.032204, 0.024491, 0.023612, 0.036589, 0.031462, 0.035541, 0.029419, 0.029933, 0.026662, 0.042193, 0.039853, 0.031803, 0.028869, 0.039875, 0.037955, 0.025239, 0.041877, 0.037843, 0.030964, 0.033953, 0.040644, 0.030769, 0.033960, 0.036657, 0.037455, 0.029659, 0.032792, 0.037595, 0.030260, 0.052511, 0.041971, 0.036526, 0.030491, 0.028178, 0.030104, 0.038823, 0.031190, 0.036627, 0.039369, 0.031921, 0.037678, 0.036373, 0.034990, 0.028372, 0.037301, 0.027799, 0.038581, 0.031321, 0.032911, 0.037703, 0.041237, 0.038093, 0.034486, 0.042739, 0.029662, 0.028417, 
                    0.034033, 0.031376, 0.032531, 0.033295, 0.031752, 0.036409, 0.033663, 0.029770, 0.032557, 0.041075, 0.039680, 0.032668, 0.032148, 0.028971, 0.033373, 0.029597, 0.038804, 0.034182, 0.034748, 0.028725, 0.026001, 0.026916, 0.028180, 0.031976, 0.032975, 0.035823, 0.034940, 0.030818, 0.030359, 0.034800, 0.024603, 0.029964, 0.029259, 0.035026, 0.037522, 0.033446, 0.036075, 0.027529, 0.033502, 0.037029, 0.028582, 0.035601, 0.034996, 0.028567, 0.047766, 0.033040, 0.025793, 0.025122, 0.031559, 0.030621, 0.031969, 0.038413, 0.027960, 0.045832, 0.031701, 0.037244, 0.034323, 0.040379, 0.031852, 0.031108, 0.041570, 0.030913, 0.034657, 0.039282, 0.032149, 0.037008, 0.037696, 0.039590, 0.038559, 0.042239, 0.041731, 0.032327, 0.035383, 0.040200, 0.024307, 0.032429, 0.045751, 0.039362, 0.045061, 0.028503, 0.039563, 0.037186, 0.038035, 0.047025, 0.029630, 0.033147, 0.037114, 0.043858, 0.038295, 0.038105, 0.041409, 0.030316, 0.038355, 0.039686, 0.034887, 0.041793, 0.031607, 0.035317)
  
  TotalDNE.TotalPolygonFaces <- c(0.036184, 0.034417, 0.019484, 0.023540, 0.024587, 0.013985, 0.028127, 0.029828, 0.020546, 0.025697, 0.020226, 0.027095, 0.027610, 0.024825, 0.014458, 0.031221, 0.018840, 0.022283, 0.018898, 0.025464, 0.015340, 0.014517, 0.019325, 0.018157, 0.023770, 0.015612, 0.014916, 0.017781, 0.031173, 0.037345, 0.013356, 0.027235, 0.019325, 0.029043, 0.014963, 0.021180, 0.020030, 0.024627, 0.019189, 0.021075, 0.017271, 0.017383, 0.019682, 0.024160, 0.016089, 0.023084, 0.026921, 0.032653, 0.024504, 0.016329, 0.024346, 0.025569, 0.016432, 0.025376, 0.020991, 0.023941, 0.018336, 0.022713, 0.025851, 0.016967, 0.023420, 0.027577, 0.026334, 0.013783, 0.025071, 0.022514, 0.029583, 0.026832, 0.018758, 0.026319, 0.024808, 0.023559, 0.029839, 0.019186, 0.023460, 0.019176, 0.017681, 0.024255, 0.017032, 0.028076, 0.023311, 0.023057, 0.025407, 0.025372, 0.024706, 0.023548, 0.024875, 0.029077, 0.023174, 0.026716, 0.029184, 0.021402, 0.025059, 0.023018, 0.021669, 0.021038, 0.026237, 0.022360, 0.022584, 0.020996, 0.025673, 
                                  0.021966, 0.024685, 0.025481, 0.025308, 0.029959, 0.018148, 0.017977, 0.019223, 0.024602, 0.022747, 0.017665, 0.016179, 0.020207, 0.024116, 0.022299, 0.013529, 0.025527, 0.022085, 0.022893, 0.019786, 0.013241, 0.016499, 0.015358, 0.014367, 0.024298, 0.025575, 0.021131, 0.025317, 0.016937, 0.017310, 0.021999, 0.022278, 0.016245, 0.029874, 0.022613, 0.017560, 0.030998, 0.018071, 0.011767, 0.021442, 0.023988, 0.027263, 0.026407, 0.027693, 0.021564, 0.027949, 0.028938, 0.020136, 0.021260, 0.026804, 0.028814, 0.016650, 0.027952, 0.028852, 0.019671, 0.021522, 0.018660, 0.024679, 0.024368, 0.028069, 0.022263, 0.023341, 0.024116, 0.023668, 0.027291, 0.024588, 0.025423, 0.021429, 0.028926, 0.029119, 0.029091, 0.025309, 0.026490, 0.026037, 0.023924, 0.029849, 0.015138, 0.022247, 0.023095, 0.038394, 0.021209, 0.022364, 0.027413, 0.023654, 0.027863, 0.033017, 0.032537, 0.032869, 0.023049, 0.024609)
  
  MedianDNE.Whole <- c(0.008733, 0.014942, 0.008465, 0.009150, 0.009288, 0.007494, 0.010222, 0.010741, 0.008444, 0.009527, 0.006716, 0.009649, 0.010133, 0.008667, 0.007423, 0.010737, 0.006780, 0.009210, 0.007505, 0.010912, 0.007595, 0.004958, 0.008906, 0.006773, 0.010460, 0.006675, 0.005637, 0.006229, 0.010753, 0.019355, 0.012591, 0.009001, 0.006284, 0.009720, 0.006847, 0.008528, 0.007185, 0.009607, 0.006916, 0.005486, 0.010210, 0.008577, 0.007471, 0.008115, 0.007503, 0.007496, 0.010835, 0.009649, 0.008443, 0.007320, 0.006938, 0.010592, 0.006392, 0.009564, 0.008297, 0.007105, 0.007677, 0.011118, 0.008425, 0.007566, 0.008522, 0.009529, 0.009624, 0.007840, 0.009801, 0.009405, 0.009336, 0.009940, 0.009553, 0.007413, 0.008191, 0.008428, 0.010258, 0.006102, 0.010592, 0.008797, 0.007112, 0.006813, 0.009297, 0.010512, 0.008154, 0.010742, 0.006813, 0.010757, 0.008598, 0.009092, 0.008469, 0.009693, 0.009519, 0.009709, 0.009701, 0.009327, 0.008510, 0.008892, 0.008478, 0.008661, 0.010455, 0.008137, 0.007596, 0.008337, 0.009170, 0.007166, 0.010193, 0.009140, 0.009043, 0.008277, 0.007824, 0.007937, 0.008148, 0.008038, 0.008518, 0.008256, 
                       0.006802, 0.007388, 0.008524, 0.008000, 0.006396, 0.007661, 0.010167, 0.008745, 0.007146, 0.007335, 0.010465, 0.005919, 0.005684, 0.009484, 0.008683, 0.008837, 0.010120, 0.008567, 0.005133, 0.007448, 0.008670, 0.007502, 0.008978, 0.009412, 0.006445, 0.010978, 0.008440, 0.006688, 0.009121, 0.008462, 0.008043, 0.007120, 0.008334, 0.008510, 0.011336, 0.010738, 0.009301, 0.009204, 0.008940, 0.010802, 0.007365, 0.009170, 0.010583, 0.007431, 0.009726, 0.007446, 0.009162, 0.008200, 0.010863, 0.008319, 0.009277, 0.009219, 0.011909, 0.010592, 0.010393, 0.012965, 0.008342, 0.009856, 0.011355, 0.010148, 0.009644, 0.008964, 0.008518, 0.009121, 0.011901, 0.007104, 0.006571, 0.010091, 0.016595, 0.008524, 0.010252, 0.010750, 0.009415, 0.008757, 0.007590, 0.010359, 0.010830, 0.009636, 0.010039)
  
  IQRDNE.Whole <- c(0.017141, 0.031096, 0.019790, 0.021605, 0.021858, 0.017564, 0.024189, 0.025123, 0.021697, 0.023193, 0.013533, 0.023601, 0.022010, 0.021741, 0.015926, 0.026144, 0.018374, 0.027377, 0.018498, 0.023599, 0.014252, 0.014183, 0.021042, 0.016294, 0.024842, 0.012628, 0.014084, 0.014405, 0.025517, 0.040475, 0.013016, 0.025306, 0.015121, 0.025283, 0.019458, 0.021667, 0.018347, 0.021910, 0.013796, 0.013058, 0.019562, 0.018200, 0.016154, 0.018216, 0.017038, 0.020225, 0.021502, 0.029235, 0.019954, 0.017395, 0.019680, 0.021878, 0.012274, 0.021868, 0.027486, 0.017244, 0.019543, 0.026671, 0.019020, 0.014700, 0.019517, 0.023875, 0.022913, 0.018086, 0.025053, 0.018881, 0.024195, 0.021371, 0.021217, 0.019396, 0.021410, 0.019084, 0.024520, 0.015177, 0.021814, 0.013421, 0.016928, 0.019263, 0.017486, 0.020140, 0.020155, 0.025538, 0.014545, 0.025887, 0.022140, 0.019108, 0.020069, 0.023894, 0.020660, 0.023928, 0.024768, 0.019236, 0.020995, 
                    0.017773, 0.016879, 0.021500, 0.022029, 0.018673, 0.019557, 0.020148, 0.023099, 0.014682, 0.018371, 0.019818, 0.021710, 0.021843, 0.019515, 0.019474, 0.015781, 0.021699, 0.020361, 0.020143, 0.015230, 0.016278, 0.020460, 0.016869, 0.013876, 0.018309, 0.020144, 0.018747, 0.014842, 0.013850, 0.019906, 0.014020, 0.014019, 0.020479, 0.018759, 0.022041, 0.021624, 0.018243, 0.020957, 0.015918, 0.021818, 0.015173, 0.021600, 0.018633, 0.011955, 0.027885, 0.015943, 0.018513, 0.013283, 0.018982, 0.021448, 0.023220, 0.024142, 0.020724, 0.028241, 0.025278, 0.021864, 0.017860, 0.020279, 0.026239, 0.017334, 0.024193, 0.022903, 0.018360, 0.025483, 0.017046, 0.025103, 0.021666, 0.029533, 0.021578, 0.021936, 0.028149, 0.021743, 0.023050, 0.025941, 0.019553, 0.021471, 0.025052, 0.023837, 0.023368, 0.021477, 0.027530, 0.021370, 0.021648, 0.026131, 0.016952, 0.018624, 0.024266, 0.042830, 0.016663, 0.024008, 0.026115, 0.018557, 0.025540, 0.016317, 0.037184, 0.027058, 0.018348, 0.025079)
  
  MeanDNE.Convex <- c(0.025755, 0.026374, 0.020147, 0.021264, 0.022466, 0.018218, 0.021230, 0.021385, 0.022424, 0.024963, 0.017201, 0.021815, 0.019871, 0.023345, 0.017320, 0.022685, 0.019620, 0.023563, 0.017871, 0.023935, 0.018342, 0.018233, 0.020546, 0.019339, 0.020190, 0.018000, 0.017234, 0.019623, 0.018386, 0.030246, 0.015559, 0.021901, 0.018012, 0.022199, 0.017249, 0.022782, 0.020512, 0.018161, 0.017221, 0.013574, 0.020509, 0.018878, 0.019501, 0.020663, 0.019559, 0.019317, 0.026744, 0.024027, 0.021968, 0.019655, 0.021586, 0.021824, 0.015671, 0.023239, 0.021528, 0.021303, 0.019128, 0.023745, 0.020142, 0.017620, 0.021549, 0.025471, 0.021820, 0.020615, 0.026894, 0.024273, 0.023680, 0.022803, 0.020391, 0.017810, 0.021544, 0.023384, 0.023218, 0.020103, 0.025769, 0.018148, 0.021205, 0.021601, 0.019260, 0.024395, 0.018490, 0.021945, 0.019897, 0.021038, 0.021617, 0.024315, 0.023445, 0.019348, 0.024449, 0.021750, 0.022094, 0.021889, 
                      0.021697, 0.021768, 0.019426, 0.019630, 0.024841, 0.021378, 0.020690, 0.019562, 0.022374, 0.020382, 0.022929, 0.024805, 0.021556, 0.022830, 0.019175, 0.018758, 0.021497, 0.022633, 0.021374, 0.018651, 0.016834, 0.020013, 0.021563, 0.021140, 0.017215, 0.017970, 0.024354, 0.020388, 0.018221, 0.017051, 0.019674, 0.017251, 0.017362, 0.021862, 0.021629, 0.020559, 0.021254, 0.021679, 0.018375, 0.018253, 0.023465, 0.018133, 0.022106, 0.022256, 0.020097, 0.025848, 0.020685, 0.018534, 0.020672, 0.021677, 0.020083, 0.022821, 0.019126, 0.021504, 0.028332, 0.020776, 0.024324, 0.020348, 0.023245, 0.021522, 0.018469, 0.022769, 0.021869, 0.021885, 0.021193, 0.019501, 0.022406, 0.021882, 0.024969, 0.019613, 0.022636, 0.023334, 0.022829, 0.021865, 0.024839, 0.022544, 0.023510, 0.025179, 0.021642, 0.020579, 0.020835, 0.023763, 0.020171, 0.021351, 0.023269, 0.019233, 0.017149, 0.023836, 0.031884, 0.022101, 0.025067, 0.022005, 0.022078, 0.019427, 0.024020, 0.026263, 0.026577, 0.020365, 0.023758)
  
  PCLR_Test <- data.frame(Age, Cluster1, MeanDNE.Apex, TotalDNE.TotalPolygonFaces, MedianDNE.Whole, IQRDNE.Whole, MeanDNE.Convex)
  PCLR_Test
}

#' @examples 
#' PCLR_Test

