% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectNormalize.R
\name{objectNormalize}
\alias{objectNormalize}
\title{Object Intensity Normalization}
\usage{
objectNormalize(
  mat,
  input_range = c(0, 4095),
  full_range = FALSE,
  force_range = FALSE,
  gamma = 1
)
}
\arguments{
\item{mat}{a finite numeric matrix.}

\item{input_range}{a finite numeric vector of 2 values, sets the range of the input intensity values. Values outside this range are clipped. Default is \code{[0,4095]}.}

\item{full_range}{if '\code{full_range}' is \code{TRUE}, then '\code{input_range}' will be set to \code{[0,4095]} and '\code{gamma}' forced to \code{1}. Default is \code{FALSE}.}

\item{force_range}{if '\code{force_range}' is \code{TRUE}, then '\code{input_range}' will be adjusted to '\code{mat}' range in \code{[-4095,+inf]} and '\code{gamma}' forced to \code{1}. Default is \code{FALSE}.\cr
Note that this parameter takes the precedence over \code{input_range}' and \code{full_range}'.}

\item{gamma}{'\code{gamma}' correction. Default is \code{1}, for no correction.}
}
\value{
a [0,1] normalized matrix
}
\description{
Normalizes a matrix to [0,1].
}
\details{
Note that negative values are used internally for removal of unmasked objects.
}
\keyword{internal}
