% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLupdater.R
\name{translateAllele}
\alias{translateAllele}
\title{Translate HLA Allele Names across IPD-IMGT/HLA Database Release Versions}
\usage{
translateAllele(allele, from, to, expand = FALSE, verbose = FALSE)
}
\arguments{
\item{allele}{A full or truncated HLA allele name.}

\item{from}{A character string identifying the IPD-IMGT/HLA Database release version of 'allele'.}

\item{to}{A character string identifying the IPD-IMGT/HLA Database release version to translate 'allele' to. Values can range from version 1.05.0 to the loaded version of the the alleleListHistory object.}

\item{expand}{A logical that indicates if the lowest-numbered truncated allele name that matches a truncated allele name should be returned (expand = FALSE), or if a slash-delimited string of all matching full-length allele names should be returned (expand = TRUE). The default value is FALSE.}

\item{verbose}{A logical that indicates if messages regarding allele translations should be sent to the console (TRUE) or not (FALSE). The default value is FALSE.}
}
\value{
A character string of either a single matching allele or all matching alleles in the 'to' release version. If an allele does not have a cognate match in 'to', NA is returned for that allele.
}
\description{
Translates a single HLA allele name across IPD-IMGT/HLA Database release versions.  Truncated allele names in one version can be expanded to a list of all allele names that match the provided allele name in a chosen version.
}
\examples{
translateAllele("A*01:01","3.01.0","2.20.0",FALSE)
translateAllele("A*0101","2.20.0","3.01.0",TRUE)
translateAllele("B*57:01","3.12.0","3.12.0",TRUE)

}
