% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_test.R
\name{print_chi2_test}
\alias{print_chi2_test}
\title{Prints the results of a Chi2}
\usage{
print_chi2_test(x, digits = 3)
}
\arguments{
\item{x}{Test object from \code{rstatix} among \code{chisq_test} or \code{fisher_test}.}

\item{digits}{Integer specifying the number of decimal places for the test
statistic.}
}
\value{
A character string containing the formatted test results with:
\describe{
\item{Test statistic}{For Chi-squared test.}
\item{P-value}{Formatted p-value with significance stars.}
\item{Sample size}{Total count for sample size.}
}
For Fisher's exact test, only the P-value and sample size are included.
}
\description{
Formats the results of a Chi-squared or Fisher's exact test.
}
\examples{
x <- c(A = 100, B = 78, C = 25)
library(rstatix)
print_chi2_test(chisq_test(x))

xtab <- as.table(rbind(c(490, 10), c(400, 100)))
dimnames(xtab) <- list(
    group = c("grp1", "grp2"),
    smoker = c("yes", "no")
)
print_chi2_test(fisher_test(xtab))

}
