% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{biplFig}
\alias{biplFig}
\title{Biplot function}
\usage{
biplFig(
  missbp,
  Z.col = "#61223b",
  CLP.col = "#b79962",
  Z.pch = 19,
  CLP.pch = 15,
  Z.cex = 1.5,
  CLP.cex = 1.7,
  title = ""
)
}
\arguments{
\item{missbp}{An object of class \code{missbp} obtained from preceding function \code{missmi()}}

\item{Z.col}{Colour of sample coordinates}

\item{CLP.col}{Colour of category level point coordinates}

\item{Z.pch}{Plotting character of sample coordinates}

\item{CLP.pch}{Plotting character of category level point coordinates}

\item{Z.cex}{Size of plotting character for sample points}

\item{CLP.cex}{Size of plotting character for category level point points}

\item{title}{Title of the plot}
}
\value{
\itemize{
\item If \code{compdat = NULL} in \code{\link{evalMeas}}, only a GPAbin biplot will be constructed.
\item If a complete data set (\code{compdat}) was specified in \code{\link{evalMeas}}, two biplots will be constructed: (1) Complete MCA biplot and (2) GPAbin biplot.
}
}
\description{
Creates a multiple correspondence analysis (MCA) biplot
}
\examples{
data(implist)
missbp <- missmi(implist)|> DRT() |> GPAbin() |> biplFig()

}
