% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{BERT_vocab}
\alias{BERT_vocab}
\title{Check if mask words are in the model vocabulary.}
\usage{
BERT_vocab(
  models,
  mask.words,
  add.tokens = FALSE,
  add.verbose = FALSE,
  weight.decay = 1
)
}
\arguments{
\item{models}{A character vector of model names at
\href{https://huggingface.co/models}{HuggingFace}.}

\item{mask.words}{Option words filling in the mask.}

\item{add.tokens}{Add new tokens (for out-of-vocabulary words or phrases) to model vocabulary? Defaults to \code{FALSE}.
\itemize{
\item Default method of producing the new token embeddings is computing the (equally weighted) average subword token embeddings. To change the weights of different subwords, specify \code{weight.decay}.
\item It just adds tokens temporarily without changing the raw model file.
}}

\item{add.verbose}{Print subwords of each new token? Defaults to \code{FALSE}.}

\item{weight.decay}{Decay factor of relative importance of multiple subwords. Defaults to \code{1} (see \code{\link[=weight_decay]{weight_decay()}} for computational details). A smaller decay value would give greater weight to the former subwords than to the latter subwords. The i-th subword has raw weight = decay ^ i.
\itemize{
\item decay = 1: all subwords are \strong{equally} important (default)
\item 0 < decay < 1: \strong{first} subwords are more important
\item decay > 1: \strong{last} subwords are more important
}

For example, decay = 0.5 would give 0.5 and 0.25 (with normalized weights 0.667 and 0.333) to two subwords (e.g., "individualism" = 0.667 "individual" + 0.333 "##ism").}
}
\value{
A data.table of model name, mask word, real token (replaced if out of vocabulary), and token id (0~N).
}
\description{
Check if mask words are in the model vocabulary.
}
\examples{
\dontrun{
models = c("bert-base-uncased", "bert-base-cased")
BERT_info(models)

BERT_vocab(models, c("bruce", "Bruce"))

BERT_vocab(models, 2020:2025)  # some are out-of-vocabulary
BERT_vocab(models, 2020:2025, add.tokens=TRUE)  # add vocab

BERT_vocab(models,
           c("individualism", "artificial intelligence"),
           add.tokens=TRUE)
}

}
\seealso{
\code{\link[=BERT_download]{BERT_download()}}

\code{\link[=BERT_info]{BERT_info()}}

\code{\link[=FMAT_run]{FMAT_run()}}
}
