% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision.R
\name{get_decision}
\alias{get_decision}
\alias{get_decision.boin_design}
\alias{get_decision.i3plus3_design}
\alias{get_decision.mtpi2_design}
\alias{get_decision.g3plus3_design}
\alias{get_decision.threethree_design}
\alias{get_decision.default}
\title{Generate Decision Tables for Phase I Dose-Finding Designs}
\usage{
get_decision(design, ...)

\method{get_decision}{boin_design}(design, ...)

\method{get_decision}{i3plus3_design}(design, ...)

\method{get_decision}{mtpi2_design}(design, ...)

\method{get_decision}{g3plus3_design}(design, ...)

\method{get_decision}{threethree_design}(design, ...)

\method{get_decision}{default}(design, ...)
}
\arguments{
\item{design}{A design object created by one of the design constructor functions
(\code{\link{design_boin}}, \code{\link{design_i3plus3}}, \code{\link{design_mtpi2}},
\code{\link{design_g3plus3}}, or \code{\link{design_3plus3}}).}

\item{...}{Additional arguments passed to methods.}
}
\value{
A list containing 'tab' (a dataframe with decisions E, S, D, or DU for each
  combination of y and n) and 'setup' (a list containing design parameters).
}
\description{
Generic function to generate dosing decisions (E, S, D or DU) for phase I dose-finding designs.
}
\examples{
# Create design specifications
boin <- design_boin(pT = 0.25, EI = c(0.15, 0.35), npts = 12)
i3 <- design_i3plus3(pT = 0.25, EI = c(0.2, 0.3), npts = 12)

# Generate decision tables
decision_boin <- get_decision(boin)
decision_i3 <- get_decision(i3)

}
