% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layard.r
\name{layard}
\alias{layard}
\title{Teste de homogeneidade de variancias de Layard}
\usage{
layard(trat, resp, t, r)
}
\arguments{
\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{t}{Escalar. Numero de tratamentos.}

\item{r}{Vetor numerico ou complexo contendo o numero de
repeticoes de cada tratamento.}
}
\value{
Retorna o valor-p do teste de homogeneidade de
variancias de Layard para uma hipotese nula de que as
variancias sao homogeneas.
}
\description{
\code{layard} Executa o teste de homogeneidade de variancias
de Layard (1973) por Jackknife para um delineamento
inteiramente casualizado.
}
\examples{
data(ex1)
attach(ex1)
dic(trat, ig, quali = FALSE, hvar = "layard")
}
\references{
LAYARD, M. N. J. Robust large-sample tests for
homogeneity of variances. \emph{Journal of the American
Statistical Association}, v.68, n.341, p.195-198, 1973.

NOGUEIRA, D, P.; PEREIRA, G, M. Desempenho de testes para
homogeneidade de variancias em delineamentos inteiramente
casualizados. \emph{Sigmae}, Alfenas, v.2, n.1, p. 7-22.
2013.
}
\seealso{
\code{\link{bartlett}}, \code{\link{samiuddin}},
\code{\link{levene}}, \code{\link{oneillmathews}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}
 @author Denismar Alves Nogueira
 @author Marcos Costa de Paula
 @author Mateus Pimenta Siqueira Lima
}
