% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dql.r
\name{dql}
\alias{dql}
\title{Delineamento em Quadrado Latino}
\usage{
dql(
  trat,
  linha,
  coluna,
  resp,
  quali = TRUE,
  mcomp = "tukey",
  sigT = 0.05,
  sigF = 0.05,
  unfold = NULL
)
}
\arguments{
\item{trat}{Vetor numerico ou complexo contendo os
tratamentos.}

\item{linha}{Vetor numerico ou complexo contendo as linhas.}

\item{coluna}{Vetor numerico ou complexo contendo as colunas.}

\item{resp}{Vetor numerico ou complexo contendo a variavel
resposta.}

\item{quali}{Logico. Se TRUE (default), os tratamentos sao
entendido como qualitativos, se FALSE, quantitativos.}

\item{mcomp}{Permite escolher o teste de comparacao
multipla; o \emph{default} e o teste de Tukey, contudo
tem-se como outras opcoes: o teste LSD ("lsd"), o teste LSDB
("lsdb"), o teste de Duncan ("duncan"), o teste de SNK
("snk"), o teste de Scott-Knott ("sk"), o teste de
comparacoes multiplas bootstrap ("ccboot") e o teste de
Calinski e Corsten baseado na distribuicao F ("ccf").}

\item{sigT}{Significancia a ser adotada pelo teste de
comparacao multipla de medias; o default e 5\%.}

\item{sigF}{Significancia a ser adotada pelo teste F da
ANAVA; o default e 5\%.}

\item{unfold}{Orienta os desdobramentos apos a analise de
variancia. Se NULL (\emph{default}), sao feitas as analises
recomendadas; se '0', e feita apenas a analise de variancia;
se '1', os efeitos simples sao estudados.}
}
\value{
Sao retornados os valores da analise de variancia do
DQL em questao, o teste de normalidade de Shapiro-Wilk para
os residuos do modelo, o ajuste de modelos de regressao
(caso de tratamentos quantitativos) ou os testes de
comparacao de medias (caso de tratamentos qualitativos):
teste de Tukey, teste de Duncan, teste t de Student (LSD),
teste t de Bonferroni, teste de Student-Newman-Keuls(SNK),
teste de Scott-Knott  e teste de comparacoes multiplas
bootstrap.
}
\description{
\code{dql} Analisa experimentos em Delineamento em Quadrado
Latino balanceado com um so fator, considerando o modelo
fixo.
}
\details{
Os argumentos sigT e mcomp so serao utilizados
quando os tratamentos forem qualitativos.
}
\note{
O \code{\link{graficos}} pode ser usado para construir
os graficos da regressao e o \code{\link{plotres}} para
analise do residuo da anava.
}
\examples{
data(ex3)
attach(ex3)
dql(trat, linha, coluna, resp, quali=TRUE, mcomp = "snk",
sigT = 0.05, sigF = 0.05, unfold=NULL)
}
\references{
GOMES, F. P. Curso de Estatistica Experimental.
10a ed. Piracicaba: ESALQ/USP. 1982. 430.

FERREIRA, E. B.; CAVALCANTI, P. P.; NOGUEIRA D. A. Funcao
em codigo R para analisar experimentos em DQL simples, em
uma so rodada. In: CONGRESSO DE POS-GRADUACAO DA
UNIVERSIDADE FEDERAL DE LAVRAS, 18., 2009, Lavras.
Annals... Lavras: UFLA, 2009.
}
\seealso{
\code{\link{dic}}, \code{\link{dbc}}.
}
\author{
Eric B Ferreira,
 \email{eric.ferreira@unifal-mg.edu.br}

Denismar Alves Nogueira

Portya Piscitelli Cavalcanti
}
