% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainer_cor_test.R
\name{trainer_cor_test}
\alias{trainer_cor_test}
\title{Interpret a correlation test (cor.test) with an audience-aware LLM prompt}
\usage{
trainer_cor_test(
  ct_obj,
  introduction = NULL,
  alpha = 0.05,
  audience = c("beginner", "applied", "advanced"),
  summary_only = FALSE,
  llm_model = "llama3",
  generate = FALSE
)
}
\arguments{
\item{ct_obj}{An htest object returned by stats::cor.test().}

\item{introduction}{Optional character string giving the study context.}

\item{alpha}{Numeric significance level (default 0.05).}

\item{audience}{One of c("beginner","applied","advanced").}

\item{summary_only}{Logical; if TRUE, return a 3-bullet executive summary
regardless of audience depth (uses trainer_core_summary_only_block()).}

\item{llm_model}{Character; model name for the generator (default "llama3").}

\item{generate}{Logical; if TRUE, call the generator and return prompt + response.}
}
\value{
If generate = FALSE, a prompt string. If TRUE, a list with
  prompt, response, and model.
}
\description{
Builds a clear, audience-tailored prompt to interpret stats::cor.test() results
for Pearson, Spearman, or Kendall correlation. Supports three audiences
("beginner", "applied", "advanced") and an optional summary_only mode.
}
\examples{
set.seed(1)
x <- rnorm(30); y <- 0.5*x + rnorm(30, sd = 0.8)
ct <- cor.test(x, y, method = "pearson")
cat(trainer_cor_test(ct, audience = "applied", summary_only = FALSE))
}
