% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{setup_optimizer}
\alias{setup_optimizer}
\title{Instantiate an optimizer for training an EQRN_iid network}
\usage{
setup_optimizer(network, learning_rate, L2_pen, hidden_fct, optim_met = "adam")
}
\arguments{
\item{network}{A \code{torch::nn_module} network to be trained in \code{\link[=EQRN_fit]{EQRN_fit()}}.}

\item{learning_rate}{Initial learning rate for the optimizer during training of the neural network.}

\item{L2_pen}{L2 weight penalty parameter for regularization during training.}

\item{hidden_fct}{Activation function for the hidden layers. Can be either a callable function (preferably from the \code{torch} library),
or one of the the strings \code{"SNN"}, \code{"SSNN"} for self normalizing networks (with common or separated networks for the scale and shape estimates, respectively).
This will affect the default choice of optimizer.}

\item{optim_met}{DEPRECATED. Optimization algorithm to use during training. \code{"adam"} is the default.}
}
\value{
A \code{torch::optimizer} object used in \code{\link[=EQRN_fit]{EQRN_fit()}} for training.
}
\description{
Instantiate an optimizer for training an EQRN_iid network
}
\keyword{internal}
