% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EQRN.R
\name{perform_scaling}
\alias{perform_scaling}
\title{Performs feature scaling without overfitting}
\usage{
perform_scaling(X, X_scaling = NULL, scale_features = TRUE, stat_attr = FALSE)
}
\arguments{
\item{X}{A covariate matrix.}

\item{X_scaling}{Existing \code{"X_scaling"} object containing the precomputed mean and variance for each covariate.
This enables reusing the scaling choice and parameters from the train set, if computing the excesses on a validation or test set,
in order to avoid overfitting. This is performed automatically in the \code{"EQRN"} objects.}

\item{scale_features}{Whether to rescale each input covariates to zero mean and unit variance before applying the model (recommended).
If \code{X_scaling} is given, \code{X_scaling$scaling} overrides \code{scale_features}.}

\item{stat_attr}{DEPRECATED. Whether to keep attributes in the returned covariate matrix itself.}
}
\value{
Named list containing:
\item{X_excesses}{the (possibly rescaled and q_feat transformed) covariate matrix,}
\item{X_scaling}{object of class \code{"X_scaling"} to use for consistent scaling on future datasets.}
}
\description{
Performs feature scaling without overfitting
}
