% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_dr.R
\name{boot_dr}
\alias{boot_dr}
\title{Dyad Ratios Algorithm}
\arguments{
\item{varname}{String giving the name of the input series to be smoothed.
This should identify similar or comparable values in the series. Values in
the series that have the same \code{varname} will be assumed to come from
the same source.}

\item{date}{ISO numeric representation of the date the survey was in the
field (usually the start, end, or median date).}

\item{index}{Numeric value of the series. It might be a percent or proportion
responding in a single category (e.g., the approve response in presidential
approval) or some multi-response summary. For ease of interpretation,
polarity should be the same for all items.}

\item{ncases}{Number of cases (e.g., sample size) of the survey. This provides
differential weighting for the values. Setting this to \code{NULL} or
leaving it blank will weight each value equally.}

\item{unit}{Aggregation period—one of \sQuote{D} (daily), \sQuote{M}
(monthly), \sQuote{Q} (quarterly), \sQuote{A} (annual), or \sQuote{O}
(multi-year aggregation).}

\item{mult}{Number of years, only used if \code{unit} is \sQuote{O}.}

\item{begindt}{Beginning date of the analysis. Defaults to earliest date in
the dataset. Should be specified with \code{lubridate::ymd()}.}

\item{enddt}{Ending date for the analysis. Defaults to the latest date in the
data.}

\item{npass}{Not yet implemented.}

\item{smoothing}{Logical. Specifies whether exponential smoothing is applied
to the intermediate estimates during the iterative solution process.
Defaults to \code{TRUE}.}

\item{endmonth}{Ending month of the analysis.}

\item{R}{Number of bootstrap samples.}

\item{parallel}{Logical indicating whether the `mclapply` function should be used.}

\item{level}{The confidence level for the intervals. Default is 0.95.}

\item{pw}{Logical indicating whether to do pairwise tests.}

\item{...}{Other arguments to be passed down to `mclapply`.}
}
\value{
A list with potentially two data frames `ci` has variables:
\itemize{
  \item \code{period}: Aggregation period. 
  \item \code{latent1}: Estimate of latent variable from original analysis.
  \item \code{lwr}: Lower confidence bound.
  \item \code{upr}: Upper confidence bound. 
}
If `pw = TRUE`, the list also contains `pw` with variables:
\itemize{
  \item \code{p1}: Earlier period 
  \item \code{p2}: Later period 
  \item \code{diff}: (mood for p2) - (mood for p1)
  \item \code{p_diff}: Probability that the larger mood is bigger than the smaller mood. 
}
}
\description{
Estimates the Dyad Ratios Algorithm for constructing latent time series from
survey-research marginals.
}
\examples{
data(jennings)
# R should be higher for real-world applications
\dontrun{
boot_out <- boot_dr(varname = jennings$variable, 
                  date = jennings$date, 
                  index = jennings$value, 
                  ncases = jennings$n, 
                  begindt = as.Date("1985-01-01"), 
                  enddt = max(jennings$date), 
                  npass=1, R=1000, 
                  parallel=FALSE)
boot_out
}
}
\references{
Stimson, J. A. (2018).
\sQuote{The Dyad Ratios Algorithm for Estimating Latent Public Opinion:
Estimation, Testing, and Comparison to Other Approaches},
\emph{Bulletin of Sociological Methodology/Bulletin de Méthodologie
Sociologique}, 137–138(1), 201–218. \doi{10.1177/0759106318761614}
}
