% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/root.R
\name{roots}
\alias{roots}
\title{One Dimensional Multiple Roots (Zero) Finding}
\usage{
roots(
  f,
  vectorized = FALSE,
  interval,
  maxerror_f = 1e-07,
  split = "seq",
  split.size = 11,
  tol = .Machine$double.eps^0.25,
  .lapply = parallel::mclapply,
  ...
)
}
\arguments{
\item{f}{Function to find roots}

\item{vectorized}{boolean: is f already vectorized ? (default: FALSE) or if function: vectorized version of f.}

\item{interval}{bounds to inverse in}

\item{maxerror_f}{the maximum error on f evaluation (iterates over uniroot to converge).}

\item{split}{function or "unif" or "seq" (default) to preform interval partition}

\item{split.size}{number of parts to perform uniroot inside}

\item{tol}{the desired accuracy (convergence tolerance on f arg).}

\item{.lapply}{control the loop/vectorization over different roots (defaults to multicore apply).}

\item{...}{additional named or unnamed arguments to be passed to f.}
}
\value{
array of x, so f(x)=target
}
\description{
Search multiple roots of 1D function, sampled/splitted by a (1D) mesh
}
\examples{
roots(sin,interval=c(pi/2,5*pi/2))
roots(sin,interval=c(pi/2,1.5*pi/2))

f=function(x)exp(x)-1;
f(roots(f,interval=c(-1,2)))

f=function(x)exp(1000*x)-1;
f(roots(f,interval=c(-1,2)))
}
