% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeResultsTo.R
\name{.writeResultsToTable}
\alias{.writeResultsToTable}
\title{Internal function to write the check results to a table in the database. Requires write access to the database}
\usage{
.writeResultsToTable(
  connectionDetails,
  resultsDatabaseSchema,
  checkResults,
  writeTableName,
  cohortDefinitionId
)
}
\arguments{
\item{connectionDetails}{A connectionDetails object for connecting to the CDM database}

\item{resultsDatabaseSchema}{The fully qualified database name of the results schema}

\item{checkResults}{A dataframe containing the fully summarized data quality check results}

\item{writeTableName}{The name of the table to be written to the database. Default is "dqdashboard_results".}

\item{cohortDefinitionId}{(OPTIONAL) The cohort definition id for the cohort you wish to run the DQD on. The package assumes a standard OHDSI cohort table called 'Cohort'
with the fields cohort_definition_id and subject_id.}
}
\value{
NULL (writes results to database table)
}
\description{
Internal function to write the check results to a table in the database. Requires write access to the database
}
\keyword{internal}
