% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DSConnection.R
\name{dsDisconnect}
\alias{dsDisconnect}
\title{Disconnect (close) a connection}
\usage{
dsDisconnect(conn, save = NULL)
}
\arguments{
\item{conn}{An object inheriting from \code{\link{DSConnection-class}}.}

\item{save}{Save DataSHIELD session in data repository with provided identifier string.}
}
\description{
This closes the connection, discards all pending work, and frees
resources (e.g., memory, sockets).
}
\examples{
\dontrun{
con <- dsConnect(DSOpal::Opal(), "server1",
  username = "dsuser", password = "password", url = "https://opal-demo.obiba.org")
dsDisconnect(con)
}
}
\seealso{
Other DSConnection generics: 
\code{\link{DSConnection-class}},
\code{\link{dsAggregate}()},
\code{\link{dsAssignExpr}()},
\code{\link{dsAssignResource}()},
\code{\link{dsAssignTable}()},
\code{\link{dsGetInfo}()},
\code{\link{dsHasResource}()},
\code{\link{dsHasSession}()},
\code{\link{dsHasTable}()},
\code{\link{dsIsAsync}()},
\code{\link{dsKeepAlive}()},
\code{\link{dsListMethods}()},
\code{\link{dsListPackages}()},
\code{\link{dsListProfiles}()},
\code{\link{dsListResources}()},
\code{\link{dsListSymbols}()},
\code{\link{dsListTables}()},
\code{\link{dsListWorkspaces}()},
\code{\link{dsRestoreWorkspace}()},
\code{\link{dsRmSymbol}()},
\code{\link{dsRmWorkspace}()},
\code{\link{dsSaveWorkspace}()},
\code{\link{dsSession}()}
}
\concept{DSConnection generics}
