% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-functions-samr-adapted.R
\name{sammy}
\alias{sammy}
\title{Significance analysis of microarrays}
\usage{
sammy(
  data,
  resp.type = c("Quantitative", "Two class unpaired", "Survival", "Multiclass",
    "One class", "Two class paired", "Two class unpaired timecourse",
    "One class timecourse", "Two class paired timecourse", "Pattern discovery"),
  assay.type = c("array", "seq"),
  s0 = NULL,
  s0.perc = NULL,
  nperms = 100,
  center.arrays = FALSE,
  testStatistic = c("standard", "wilcoxon"),
  time.summary.type = c("slope", "signed.area"),
  regression.method = c("standard", "ranks"),
  return.x = FALSE,
  knn.neighbors = 10,
  random.seed = NULL,
  nresamp = 20,
  nresamp.perm = NULL,
  xl.mode = c("regular", "firsttime", "next20", "lasttime"),
  xl.time = NULL,
  xl.prevfit = NULL
)
}
\arguments{
\item{data}{Data object with components x- p by n matrix of features, one
observation per column (missing values allowed); y- n-vector of outcome
measurements; censoring.status- n-vector of censoring censoring.status
(1= died or event occurred, 0=survived, or event was censored), needed for a
censored survival outcome}

\item{resp.type}{Problem type: "Quantitative" for a continuous parameter
(Available for both array and sequencing data); "Two class unpaired" (for
both array and sequencing data); "Survival" for censored survival outcome
(for both array and sequencingdata); "Multiclass": more than 2 groups (for
both array and sequencing data); "One class" for a single group (only for
array data); "Two class paired" for two classes with paired observations
(for both array and sequencing data); "Two class unpaired timecourse" (only
for array data), "One class time course" (only for array data),
"Two class.paired timecourse" (only for array data), or "Pattern discovery"
(only for array data)}

\item{assay.type}{Assay type: "array" for microarray data, "seq" for counts
from sequencing}

\item{s0}{Exchangeability factor for denominator of test statistic; Default
is automatic choice. Only used for array data.}

\item{s0.perc}{Percentile of standard deviation values to use for s0; default
is automatic choice; -1 means s0=0 (different from s0.perc=0, meaning
s0=zeroeth percentile of standard deviation values= min of sd values.
Only used for array data.}

\item{nperms}{Number of permutations used to estimate false discovery rates}

\item{center.arrays}{Should the data for each sample (array) be median
centered at the outset? Default =FALSE. Only used for array data.}

\item{testStatistic}{Test statistic to use in two class unpaired case.Either
"standard" (t-statistic) or ,"wilcoxon" (Two-sample wilcoxon or Mann-Whitney
test). Only used for array data.}

\item{time.summary.type}{Summary measure for each time course: "slope", or
"signed.area"). Only used for array data.}

\item{regression.method}{Regression method for quantitative case: "standard",
(linear least squares) or "ranks" (linear least squares on ranked data).
Only used for array data.}

\item{return.x}{Should the matrix of feature values be returned? Only useful
for time course data, where x contains summaries of the features over time.
Otherwise x is the same as the input data}

\item{knn.neighbors}{Number of nearest neighbors to use for imputation of
missing features values. Only used for array data.}

\item{random.seed}{Optional initial seed for random number generator
(integer)}

\item{nresamp}{For assay.type="seq", number of resamples used to construct
test statistic. Default 20. Only used for sequencing data.}

\item{nresamp.perm}{For assay.type="seq", number of resamples used to
construct test statistic for permutations. Default is equal to nresamp and it
must be at most nresamp. Only used for sequencing data.}

\item{xl.mode}{Used by Excel interface}

\item{xl.time}{Used by Excel interface}

\item{xl.prevfit}{Used by Excel interface}
}
\description{
This function is an adaptation of `samr::samr`
}
