% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_NLMETemplate.R
\name{output_NLMETemplate}
\alias{output_NLMETemplate}
\title{Generate NLME Model Template from JSON Specification}
\usage{
output_NLMETemplate(args)
}
\arguments{
\item{args}{A character vector where each element is a string in the format
"key=value". The function parses these strings to set up the model
generation process. The following keys are expected:
\itemize{
\item \code{model_setup}: The file path to the input JSON file that defines the NLME model structure, parameters, covariates, and error models.
\item \code{template_path}: The destination file path for the output model template.
\item \code{tokens_path}: The destination file path for the output JSON tokens file.
\item \code{data_path}: The file path to the dataset that will be used with the model.
\item \code{author}: A string specifying the name of the author to be embedded in the output files.
\item \code{description}: A string providing a description of the model to be embedded in the output files.
}}
}
\value{
This function does not return a value to the R environment. It is executed
for its side effect of writing two files:
\enumerate{
\item A model template file to the location specified by \code{template_path}.
\item A tokens JSON file to the location specified by \code{tokens_path}.
}
}
\description{
This function serves as a command-line argument parser that calls an
internal function (\code{output_NLMETemplateInternal}) to generate NLME (Non-Linear
Mixed Effects) model templates. It takes a series of "key=value" pairs,
processes a detailed JSON model specification, and outputs a model template
file and a corresponding tokens file, which can be used for model fitting.
}
\examples{
\dontrun{
# Example of the arguments that would be passed to the function.
# In a real scenario, these might come from a command-line call.

arguments <- c(
  "model_setup=./model_definition.json",
  "template_path=./template.txt",
  "tokens_path=./tokens.json",
  "data_path=./pk_data.csv",
  "author=Jane Doe",
  "description=2-compartment PK model with first-order absorption and linear elimination"
)

# Execute the function with the defined arguments
output_NLMETemplate(args = arguments)

}

}
\seealso{
The core logic is handled by the internal function \code{output_NLMETemplateInternal}.
The final file writing is performed by \code{write_ModelTemplateTokens}.
}
