% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMLStructureCustom.R
\name{add_CustomSpace}
\alias{add_CustomSpace}
\title{Add a Custom Space to a PMLModels Object}
\usage{
add_CustomSpace(Spaces, CustomCode, SpaceName = character())
}
\arguments{
\item{Spaces}{A \code{PMLModels} object (a named list) representing the existing
collection of model spaces to which the new custom space will be added.
This can be an empty list or a previously created \code{PMLModels} object.}

\item{CustomCode}{A character string containing the complete custom PML code
(e.g., the content of a \verb{test()\{...\}} block, potentially excluding the
\verb{test()\{} and closing \verb{\}} depending on usage context, although including
them is safer for parsing). Multi-line strings are collapsed. Cannot be empty.}

\item{SpaceName}{An optional character string specifying the name for this
custom model space. This name will be used as the key for this model within
the returned \code{PMLModels} list. If omitted or an empty string (\code{""}), a
unique identifier will be created by concatenating the letter
\code{"l"} with the number of characters in \code{CustomCode}. Providing a meaningful
name is recommended for clarity, especially when working with multiple custom models.
Ensure provided names are unique if creating multiple custom spaces intended
to coexist.}
}
\value{
An updated \code{PMLModels} object (a named list) containing all the
original spaces plus the newly added custom space.
}
\description{
Adds a new model space, defined by custom PML code, to an existing collection
of model spaces (a \code{PMLModels} object).
}
\details{
This function serves as a wrapper around \code{\link[=create_CustomSpace]{create_CustomSpace()}}. It first
calls \code{create_CustomSpace} using the provided \code{CustomCode} and \code{SpaceName}
to parse the code and create a representation of the new custom space.
The name of this new space is either the provided \code{SpaceName} or one
automatically generated by \code{create_CustomSpace} if \code{SpaceName} was omitted
or empty (e.g., \code{"l<number>"} based on code length).
}
\examples{
# Start with some built-in models
pk_models <- create_ModelPK(CompartmentsNumber = 1)

# Define custom code
custom_pml <- "test() {
  cfMicro(A1, Cl / V)
  dosepoint(A1)
  C = A1 / V
  error(CEps = 1)
  observe(CObs = C + CEps)
  stparm(V = tvV * exp(nV))
  stparm(Cl = tvCl * exp(nCl))
  fixef(tvV = c(, 1, ))
  fixef(tvCl = c(, 1, ))
  ranef(block(nV, nCl) = c(1, 0.001, 1))
}
"

# Add custom space with an explicit name
all_models <-
  add_CustomSpace(pk_models, custom_pml, SpaceName = "1cptOmegaBlock")
names(all_models)

# Add another custom space with auto-generated name
all_models_2 <- add_CustomSpace(all_models,
  "test() {
  cfMicro(A1, Cl / V)
  dosepoint(A1)
  C = A1 / V
  error(CEps = 1)
  observe(CObs = C + C ^ (0.5) * CEps)
  stparm(V = tvV * exp(nV))
  stparm(Cl = tvCl * exp(nCl))
  fixef(tvV = c(, 1, ))
  fixef(tvCl = c(, 1, ))
  ranef(block(nV, nCl) = c(1, 0.001, 1))
}
")
names(all_models_2) # Will include original names + "l<number>"

}
\seealso{
\code{\link[=create_CustomSpace]{create_CustomSpace()}}, \code{\link[=add_Spaces]{add_Spaces()}}, \code{\link[=create_ModelPK]{create_ModelPK()}},
\code{\link[=create_ModelPD]{create_ModelPD()}}
}
