% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_models_loo.R
\name{compare_models_loo}
\alias{compare_models_loo}
\title{Compare Bayesian Models Using PSIS-LOO}
\usage{
compare_models_loo(..., k = 0.7, name_log = "log_lik")
}
\arguments{
\item{...}{Two or more \code{stanfit} model objects to compare. Each model must include pointwise log-likelihood values (usually named \code{log_lik}) stored in the generated quantities or transformed parameters block.}

\item{k}{A numeric value specifying the Pareto-k diagnostic threshold. Default is 0.7.}

\item{name_log}{A character string specifying the name of the log-likelihood parameter in the model. Default is \code{"log_lik"}.}
}
\value{
A list with the following elements:
\describe{
\item{\code{p_loo}}{A ggplot object showing \code{elpd_loo} values and standard errors for each model.}
\item{\code{comparison}}{A \code{loo_compare} table comparing the relative fit of the models.}
\item{\code{models_loo}}{A named list of individual \code{loo} objects for each model.}
}
}
\description{
This function compares multiple Bayesian models using PSIS-LOO (Pareto-smoothed importance sampling leave-one-out cross-validation)
from the \code{loo} package. It returns a comparison table and a plot of the estimated ELPD (expected log predictive density) with standard errors.
}
\details{
This function performs PSIS-LOO diagnostics on each model, creates a visual summary, and ranks them using \code{loo_compare}.
Ensure that each model includes pointwise log-likelihood values named consistently (e.g., \code{"log_lik"}).
}
